/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.core.web.front;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.util.UrlPathHelper;

public class URLHelper {
    public static int getPageNo(HttpServletRequest request) {
        return URLHelper.getPageNo(URLHelper.getURI(request));
    }

    public static String[] getPaths(HttpServletRequest request) {
        return URLHelper.getPaths(URLHelper.getURI(request));
    }

    public static String[] getParams(HttpServletRequest request) {
        return URLHelper.getParams(URLHelper.getURI(request));
    }

    private static String getURI(HttpServletRequest request) {
        UrlPathHelper helper = new UrlPathHelper();
        String uri = helper.getOriginatingRequestUri(request);
        String ctx = helper.getOriginatingContextPath(request);
        if (!StringUtils.isBlank((String)ctx)) {
            return uri.substring(ctx.length());
        }
        return uri;
    }

    public static PageInfo getPageInfo(HttpServletRequest request) {
        UrlPathHelper helper = new UrlPathHelper();
        String uri = helper.getOriginatingRequestUri(request);
        String queryString = helper.getOriginatingQueryString(request);
        return URLHelper.getPageInfo(uri, queryString);
    }

    public static int getPageNo(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI can not be null");
        }
        if (!uri.startsWith("/")) {
            throw new IllegalArgumentException("URI must start width '/'");
        }
        int pageNo = 1;
        int bi = uri.indexOf("_");
        int mi = uri.indexOf("-");
        int pi = uri.indexOf(".");
        if (bi != -1) {
            String pageNoStr = mi != -1 ? uri.substring(bi + 1, mi) : (pi != -1 ? uri.substring(bi + 1, pi) : uri.substring(bi + 1));
            try {
                pageNo = Integer.valueOf(pageNoStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pageNo;
    }

    public static String[] getPaths(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI can not be null");
        }
        if (!uri.startsWith("/")) {
            throw new IllegalArgumentException("URI must start width '/'");
        }
        int bi = uri.indexOf("_");
        int mi = uri.indexOf("-");
        int pi = uri.indexOf(".");
        String pathStr = bi != -1 ? uri.substring(0, bi) : (mi != -1 ? uri.substring(0, mi) : (pi != -1 ? uri.substring(0, pi) : uri));
        String[] paths = StringUtils.split((String)pathStr, (char)'/');
        return paths;
    }

    public static String[] getParams(String uri) {
        String[] params;
        if (uri == null) {
            throw new IllegalArgumentException("URI can not be null");
        }
        if (!uri.startsWith("/")) {
            throw new IllegalArgumentException("URI must start width '/'");
        }
        int mi = uri.indexOf("-");
        int pi = uri.indexOf(".");
        if (mi != -1) {
            String paramStr = pi != -1 ? uri.substring(mi, pi) : uri.substring(mi);
            params = new String[StringUtils.countMatches((String)paramStr, (String)"-")];
            int fromIndex = 1;
            int nextIndex = 0;
            int i = 0;
            while ((nextIndex = paramStr.indexOf("-", fromIndex)) != -1) {
                params[i++] = paramStr.substring(fromIndex, nextIndex);
                fromIndex = nextIndex + 1;
            }
            params[i++] = paramStr.substring(fromIndex);
        } else {
            params = new String[]{};
        }
        return params;
    }

    public static PageInfo getPageInfo(String uri, String queryString) {
        if (uri == null) {
            return null;
        }
        if (!uri.startsWith("/")) {
            throw new IllegalArgumentException("URI must start width '/'");
        }
        int bi = uri.indexOf("_");
        int mi = uri.indexOf("-");
        int pi = uri.indexOf(".");
        int lastSpt = uri.lastIndexOf("/") + 1;
        String url = !StringUtils.isBlank((String)queryString) ? String.valueOf(uri) + "?" + queryString : uri;
        String urlFormer = bi != -1 ? uri.substring(lastSpt, bi) : (mi != -1 ? uri.substring(lastSpt, mi) : (pi != -1 ? uri.substring(lastSpt, pi) : uri.substring(lastSpt)));
        String urlLater = mi != -1 ? url.substring(mi) : (pi != -1 ? url.substring(pi) : url.substring(uri.length()));
        String href = url.substring(lastSpt);
        return new PageInfo(href, urlFormer, urlLater);
    }

    public static class PageInfo {
        private String href;
        private String hrefFormer;
        private String hrefLatter;

        public PageInfo(String href, String hrefFormer, String hrefLatter) {
            this.href = href;
            this.hrefFormer = hrefFormer;
            this.hrefLatter = hrefLatter;
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public String getHrefFormer() {
            return this.hrefFormer;
        }

        public void setHrefFormer(String hrefFormer) {
            this.hrefFormer = hrefFormer;
        }

        public String getHrefLatter() {
            return this.hrefLatter;
        }

        public void setHrefLatter(String hrefLatter) {
            this.hrefLatter = hrefLatter;
        }
    }
}

