/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio;

import info.aduna.lang.FileFormat;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.rio.UnsupportedRDFormatException;

public class Rio {
    public static RDFFormat getParserFormatForMIMEType(String mimeType) {
        return Rio.getParserFormatForMIMEType(mimeType, null);
    }

    public static RDFFormat getParserFormatForMIMEType(String mimeType, RDFFormat fallback) {
        return (RDFFormat)RDFFormat.matchMIMEType((String)mimeType, (Iterable)RDFParserRegistry.getInstance().getKeys(), (FileFormat)fallback);
    }

    public static RDFFormat getParserFormatForFileName(String fileName) {
        return Rio.getParserFormatForFileName(fileName, null);
    }

    public static RDFFormat getParserFormatForFileName(String fileName, RDFFormat fallback) {
        return (RDFFormat)RDFFormat.matchFileName((String)fileName, (Iterable)RDFParserRegistry.getInstance().getKeys(), (FileFormat)fallback);
    }

    public static RDFFormat getWriterFormatForMIMEType(String mimeType) {
        return Rio.getWriterFormatForMIMEType(mimeType, null);
    }

    public static RDFFormat getWriterFormatForMIMEType(String mimeType, RDFFormat fallback) {
        return (RDFFormat)RDFFormat.matchMIMEType((String)mimeType, (Iterable)RDFWriterRegistry.getInstance().getKeys(), (FileFormat)fallback);
    }

    public static RDFFormat getWriterFormatForFileName(String fileName) {
        return Rio.getWriterFormatForFileName(fileName, null);
    }

    public static RDFFormat getWriterFormatForFileName(String fileName, RDFFormat fallback) {
        return (RDFFormat)RDFFormat.matchFileName((String)fileName, (Iterable)RDFWriterRegistry.getInstance().getKeys(), (FileFormat)fallback);
    }

    public static RDFParser createParser(RDFFormat format) throws UnsupportedRDFormatException {
        RDFParserFactory factory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getParser();
        }
        throw new UnsupportedRDFormatException("No parser factory available for RDF format " + (Object)((Object)format));
    }

    public static RDFParser createParser(RDFFormat format, ValueFactory valueFactory) throws UnsupportedRDFormatException {
        RDFParser rdfParser = Rio.createParser(format);
        rdfParser.setValueFactory(valueFactory);
        return rdfParser;
    }

    public static RDFWriter createWriter(RDFFormat format, OutputStream out) throws UnsupportedRDFormatException {
        RDFWriterFactory factory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getWriter(out);
        }
        throw new UnsupportedRDFormatException("No writer factory available for RDF format " + (Object)((Object)format));
    }

    public static RDFWriter createWriter(RDFFormat format, Writer writer) throws UnsupportedRDFormatException {
        RDFWriterFactory factory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getWriter(writer);
        }
        throw new UnsupportedRDFormatException("No writer factory available for RDF format " + (Object)((Object)format));
    }

    public static void main(String[] args) throws IOException, RDFParseException, RDFHandlerException, UnsupportedRDFormatException {
        if (args.length < 2) {
            System.out.println("Usage: java org.openrdf.rio.Rio <inputFile> <outputFile>");
            return;
        }
        String inputFile = args[0];
        FileInputStream inStream = new FileInputStream(inputFile);
        RDFFormat inputFormat = Rio.getParserFormatForFileName(inputFile, RDFFormat.RDFXML);
        RDFParser rdfParser = Rio.createParser(inputFormat);
        String outputFile = args[1];
        FileOutputStream outStream = new FileOutputStream(outputFile);
        RDFFormat outputFormat = Rio.getWriterFormatForFileName(outputFile, RDFFormat.RDFXML);
        RDFWriter rdfWriter = Rio.createWriter(outputFormat, outStream);
        rdfParser.setRDFHandler(rdfWriter);
        rdfParser.parse(inStream, "file:" + inputFile);
        inStream.close();
        outStream.close();
    }
}

