/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.orientdb;

import com.orientechnologies.orient.core.index.OIndex;
import com.tinkerpop.blueprints.pgm.AutomaticIndex;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientElement;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientGraph;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientIndex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OrientAutomaticIndex<T extends OrientElement>
extends OrientIndex<T>
implements AutomaticIndex<T> {
    Set<String> autoIndexKeys = null;
    private static final String KEYS = "keys";

    public OrientAutomaticIndex(OrientGraph graph, String indexName, Class<T> indexClass, Set<String> indexKeys) {
        super(graph, indexName, indexClass, Index.Type.AUTOMATIC, null);
        if (indexKeys != null) {
            this.autoIndexKeys = new HashSet<String>(indexKeys);
        }
        this.init();
        this.saveConfiguration();
    }

    public OrientAutomaticIndex(OrientGraph graph, OIndex rawIndex) {
        super(graph, rawIndex);
        this.init();
    }

    @Override
    public Index.Type getIndexType() {
        return Index.Type.AUTOMATIC;
    }

    protected void autoUpdate(String key, Object newValue, Object oldValue, T element) {
        if (this.getIndexClass().isAssignableFrom(element.getClass()) && (this.autoIndexKeys == null || this.autoIndexKeys.contains(key))) {
            if (oldValue != null) {
                this.removeBasic(key + "!=!" + oldValue, element);
            }
            this.putBasic(key + "!=!" + newValue, element);
        }
    }

    protected void autoRemove(String key, Object oldValue, T element) {
        if (this.getIndexClass().isAssignableFrom(element.getClass()) && (this.autoIndexKeys == null || this.autoIndexKeys.contains(key))) {
            this.removeBasic(key + "!=!" + oldValue, element);
        }
    }

    public Set<String> getAutoIndexKeys() {
        return this.autoIndexKeys;
    }

    private void init() {
        Collection field = (Collection)this.underlying.getConfiguration().field(KEYS);
        if (null != field) {
            this.autoIndexKeys = new HashSet<String>();
            for (Object key : field) {
                this.autoIndexKeys.add((String)key);
            }
        }
    }

    private void saveConfiguration() {
        this.underlying.getConfiguration().field(KEYS, this.autoIndexKeys);
        this.graph.saveIndexConfiguration();
    }
}

