/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.orientdb;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientAutomaticIndex;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientGraph;
import java.util.HashSet;
import java.util.Set;

public abstract class OrientElement
implements Element,
OSerializableStream,
OIdentifiable {
    protected static final String LABEL = "label";
    protected final OrientGraph graph;
    protected final ODocument rawElement;

    protected OrientElement(OrientGraph rawGraph, ODocument rawElement) {
        this.graph = rawGraph;
        this.rawElement = rawElement;
    }

    public void setProperty(String key, Object value) {
        if (key.equals("id") || key.equals(LABEL) && this instanceof Edge) {
            throw new RuntimeException(key + " is a reserved property key");
        }
        this.graph.autoStartTransaction();
        try {
            Object oldValue = this.getProperty(key);
            for (OrientAutomaticIndex<? extends OrientElement> autoIndex : this.graph.getAutoIndices()) {
                autoIndex.autoUpdate(key, value, oldValue, this);
            }
            this.rawElement.field(key, value);
            this.graph.getRawGraph().save((ORecordInternal)this.rawElement);
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (RuntimeException e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Object removeProperty(String key) {
        this.graph.autoStartTransaction();
        try {
            Object oldValue = this.rawElement.removeField(key);
            if (null != oldValue) {
                for (OrientAutomaticIndex<? extends OrientElement> autoIndex : this.graph.getAutoIndices()) {
                    autoIndex.autoRemove(key, oldValue, this);
                }
            }
            this.save();
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            return oldValue;
        }
        catch (RuntimeException e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Object getProperty(String key) {
        if (key == null) {
            return null;
        }
        if (key.equals("_class")) {
            return this.rawElement.getSchemaClass().getName();
        }
        if (key.equals("_version")) {
            return this.rawElement.getVersion();
        }
        if (key.equals("_rid")) {
            return this.rawElement.getIdentity().toString();
        }
        return this.rawElement.field(key);
    }

    public Set<String> getPropertyKeys() {
        String[] fields;
        HashSet<String> result = new HashSet<String>();
        for (String field : fields = this.rawElement.fieldNames()) {
            if (field.equals(LABEL)) continue;
            result.add(field);
        }
        return result;
    }

    public Object getId() {
        return this.getIdentity();
    }

    protected void save() {
        this.rawElement.save();
    }

    public ODocument getRawElement() {
        return this.rawElement;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rawElement == null ? 0 : this.rawElement.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrientElement other = (OrientElement)obj;
        return !(this.rawElement == null ? other.rawElement != null : !this.rawElement.equals((Object)other.rawElement));
    }

    public byte[] toStream() throws OSerializationException {
        return this.rawElement.getIdentity().toString().getBytes();
    }

    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        ((ORecordId)this.rawElement.getIdentity()).fromString(new String(iStream));
        this.rawElement.setInternalStatus(ORecordElement.STATUS.NOT_LOADED);
        return this;
    }

    public ORID getIdentity() {
        ORID rid = this.rawElement.getIdentity();
        this.save();
        return rid;
    }

    public ORecord<?> getRecord() {
        return this.rawElement;
    }

    public int compare(OIdentifiable iFirst, OIdentifiable iSecond) {
        if (iFirst == null || iSecond == null) {
            return -1;
        }
        return iFirst.compareTo((Object)iSecond);
    }

    public int compareTo(OIdentifiable iOther) {
        if (iOther == null) {
            return 1;
        }
        ORID myRID = this.getIdentity();
        ORID otherRID = iOther.getIdentity();
        if (myRID == null && otherRID == null) {
            return 0;
        }
        return myRID.compareTo((Object)otherRID);
    }
}

