/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.orientdb;

import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.tinkerpop.blueprints.pgm.AutomaticIndex;
import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.IndexableGraph;
import com.tinkerpop.blueprints.pgm.MetaGraph;
import com.tinkerpop.blueprints.pgm.Parameter;
import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientAutomaticIndex;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientEdge;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientElement;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientGraphContext;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientIndex;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientVertex;
import com.tinkerpop.blueprints.pgm.impls.orientdb.util.OrientElementSequence;
import com.tinkerpop.blueprints.pgm.util.AutomaticIndexHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OrientGraph
implements TransactionalGraph,
IndexableGraph,
MetaGraph<OGraphDatabase> {
    private static final String ADMIN = "admin";
    private String url;
    private String username;
    private String password;
    private static final ThreadLocal<OrientGraphContext> threadContext = new ThreadLocal();
    private static final List<OrientGraphContext> contexts = new ArrayList<OrientGraphContext>();

    public OrientGraph(OGraphDatabase iDatabase) {
        this.reuse(iDatabase);
    }

    public OrientGraph(String url) {
        this(url, ADMIN, ADMIN);
    }

    public OrientGraph(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.openOrCreate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Element> AutomaticIndex<T> createAutomaticIndex(String indexName, Class<T> indexClass, Set<String> indexKeys, Parameter ... indexParameters) {
        OrientGraphContext context = this.getContext(true);
        List<OrientGraphContext> list = contexts;
        synchronized (list) {
            if (context.autoIndices.containsKey(indexName)) {
                throw new RuntimeException("Index already exists: " + indexName);
            }
            OrientAutomaticIndex<T> index = new OrientAutomaticIndex<T>(this, indexName, indexClass, indexKeys);
            for (OrientGraphContext ctx : contexts) {
                ctx.autoIndices.put(index.getIndexName(), index);
            }
            this.saveIndexConfiguration();
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Element> Index<T> createManualIndex(String indexName, Class<T> indexClass, Parameter ... indexParameters) {
        OrientGraphContext context = this.getContext(true);
        List<OrientGraphContext> list = contexts;
        synchronized (list) {
            if (context.manualIndices.containsKey(indexName)) {
                throw new RuntimeException("Index already exists: " + indexName);
            }
            OrientIndex index = new OrientIndex(this, indexName, indexClass, Index.Type.MANUAL, null);
            for (OrientGraphContext ctx : contexts) {
                ctx.manualIndices.put(index.getIndexName(), index);
            }
            this.saveIndexConfiguration();
            return index;
        }
    }

    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        OrientGraphContext context = this.getContext(true);
        Index index = context.manualIndices.get(indexName);
        if (null == index && null == (index = (Index)context.autoIndices.get(indexName))) {
            return null;
        }
        if (indexClass.isAssignableFrom(index.getIndexClass())) {
            return index;
        }
        throw new RuntimeException("Can not convert " + index.getIndexClass() + " to " + indexClass);
    }

    public Iterable<Index<? extends Element>> getIndices() {
        OrientGraphContext context = this.getContext(true);
        ArrayList<Index<? extends Element>> list = new ArrayList<Index<? extends Element>>();
        for (Index index : context.manualIndices.values()) {
            list.add(index);
        }
        for (Index index : context.autoIndices.values()) {
            list.add((Index<? extends Element>)index);
        }
        return list;
    }

    protected Iterable<OrientIndex<? extends OrientElement>> getManualIndices() {
        return this.getContext((boolean)true).manualIndices.values();
    }

    protected Iterable<OrientAutomaticIndex<? extends OrientElement>> getAutoIndices() {
        return this.getContext((boolean)true).autoIndices.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(String indexName) {
        this.autoStartTransaction();
        try {
            List<OrientGraphContext> list = contexts;
            synchronized (list) {
                for (OrientGraphContext ctx : contexts) {
                    ctx.manualIndices.remove(indexName);
                    ctx.autoIndices.remove(indexName);
                }
            }
            this.getRawGraph().getMetadata().getIndexManager().dropIndex(indexName);
            this.saveIndexConfiguration();
            this.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (Exception e) {
            this.stopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Vertex addVertex(Object id) {
        OGraphDatabase db = this.getRawGraph();
        this.autoStartTransaction();
        try {
            OrientVertex vertex = new OrientVertex(this, db.createVertex(null));
            vertex.save();
            this.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            return vertex;
        }
        catch (RuntimeException e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        OGraphDatabase db = this.getRawGraph();
        this.autoStartTransaction();
        try {
            ODocument edgeDoc = db.createEdge(((OrientVertex)outVertex).getRawElement(), ((OrientVertex)inVertex).getRawElement());
            OrientEdge edge = new OrientEdge(this, edgeDoc, label);
            db.save((ORecordInternal)((OrientVertex)outVertex).getRawElement());
            db.save((ORecordInternal)((OrientVertex)inVertex).getRawElement());
            edge.save();
            this.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            return edge;
        }
        catch (RuntimeException e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Vertex getVertex(Object id) {
        ORID rid;
        if (null == id) {
            throw new IllegalArgumentException("Element identifier cannot be null");
        }
        if (id instanceof ORID) {
            rid = (ORID)id;
        } else {
            try {
                rid = new ORecordId(id.toString());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        if (!rid.isValid()) {
            return null;
        }
        ODocument doc = (ODocument)this.getRawGraph().load(rid);
        if (doc != null) {
            return new OrientVertex(this, doc);
        }
        return null;
    }

    public void removeVertex(Vertex vertex) {
        OrientVertex oVertex = (OrientVertex)vertex;
        if (oVertex == null || oVertex.getRawElement() == null) {
            return;
        }
        this.autoStartTransaction();
        try {
            AutomaticIndexHelper.removeElement((IndexableGraph)this, (Element)vertex);
            HashSet<Edge> allEdges = new HashSet<Edge>();
            for (Edge edge : oVertex.getInEdges(new String[0])) {
                allEdges.add(edge);
            }
            for (Edge edge : oVertex.getOutEdges(new String[0])) {
                allEdges.add(edge);
            }
            for (Edge edge : allEdges) {
                AutomaticIndexHelper.removeElement((IndexableGraph)this, (Element)edge);
            }
            for (Index index : this.getManualIndices()) {
                OrientIndex idx;
                if (Vertex.class.isAssignableFrom(index.getIndexClass())) {
                    idx = (OrientIndex)index;
                    idx.removeElement(oVertex);
                }
                if (!Edge.class.isAssignableFrom(index.getIndexClass())) continue;
                idx = (OrientIndex)index;
                for (Edge e : allEdges) {
                    idx.removeElement((OrientEdge)e);
                }
            }
            this.getRawGraph().removeVertex(oVertex.rawElement);
            this.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (RuntimeException e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Iterable<Vertex> getVertices() {
        return this.getVertices(true);
    }

    private Iterable<Vertex> getVertices(boolean polymorphic) {
        OGraphDatabase db = this.getRawGraph();
        return new OrientElementSequence(this, (Iterator<?>)new ORecordIteratorClass((ODatabaseRecord)db, (ODatabaseRecordAbstract)db.getUnderlying(), "OGraphVertex", polymorphic));
    }

    public Iterable<Edge> getEdges() {
        return this.getEdges(true);
    }

    private Iterable<Edge> getEdges(boolean polymorphic) {
        OGraphDatabase db = this.getRawGraph();
        return new OrientElementSequence(this, (Iterator<?>)new ORecordIteratorClass((ODatabaseRecord)db, (ODatabaseRecordAbstract)db.getUnderlying(), "OGraphEdge", polymorphic));
    }

    public Edge getEdge(Object id) {
        ORID rid;
        if (null == id) {
            throw new IllegalArgumentException("Element identifier cannot be null");
        }
        if (id instanceof ORID) {
            rid = (ORID)id;
        } else {
            try {
                rid = new ORecordId(id.toString());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        ODocument doc = (ODocument)this.getRawGraph().load(rid);
        if (doc != null) {
            return new OrientEdge(this, doc);
        }
        return null;
    }

    public void removeEdge(Edge edge) {
        OrientEdge oEdge = (OrientEdge)edge;
        if (oEdge == null || oEdge.getRawElement() == null) {
            return;
        }
        this.autoStartTransaction();
        try {
            AutomaticIndexHelper.removeElement((IndexableGraph)this, (Element)edge);
            for (Index index : this.getManualIndices()) {
                if (!Edge.class.isAssignableFrom(index.getIndexClass())) continue;
                OrientIndex idx = (OrientIndex)index;
                idx.removeElement(oEdge);
            }
            this.getRawGraph().removeEdge(oEdge.rawElement);
            this.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (RuntimeException e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrientGraph reuse(OGraphDatabase iDatabase) {
        this.url = iDatabase.getURL();
        this.url = iDatabase.getUser() != null ? iDatabase.getUser().getName() : null;
        OrientGraph orientGraph = this;
        synchronized (orientGraph) {
            OrientGraphContext context = threadContext.get();
            if (context == null || context.rawGraph != iDatabase) {
                this.removeContext();
                context = new OrientGraphContext();
                context.rawGraph = iDatabase;
                iDatabase.checkForGraphSchema();
                threadContext.set(context);
            }
        }
        return this;
    }

    public void clear() {
        OrientGraphContext context = this.getContext(true);
        int previousMaxBufferSize = context.txBuffer;
        for (Index<? extends Element> index : this.getIndices()) {
            this.dropIndex(index.getIndexName());
        }
        this.getRawGraph().delete();
        threadContext.set(null);
        this.openOrCreate(false);
        this.setMaxBufferSize(previousMaxBufferSize);
        this.createAutomaticIndex("vertices", OrientVertex.class, null, new Parameter[0]);
        this.createAutomaticIndex("edges", OrientEdge.class, null, new Parameter[0]);
    }

    public void shutdown() {
        this.removeContext();
        this.url = null;
        this.username = null;
        this.password = null;
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.getRawGraph().getURL());
    }

    public OGraphDatabase getRawGraph() {
        return this.getContext((boolean)true).rawGraph;
    }

    public void startTransaction() {
        OrientGraphContext context = this.getContext(true);
        if (!(context.rawGraph.getTransaction() instanceof OTransactionNoTx) && context.rawGraph.getTransaction().getStatus() == OTransaction.TXSTATUS.BEGUN) {
            throw new RuntimeException("Stop current transaction before starting another");
        }
        context.rawGraph.begin();
    }

    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (conclusion == TransactionalGraph.Conclusion.FAILURE) {
            this.getRawGraph().rollback();
        } else {
            this.getRawGraph().commit();
        }
        this.getContext((boolean)true).txCounter = 0;
    }

    public void setMaxBufferSize(int bufferSize) {
        this.getRawGraph().commit();
        OrientGraphContext context = this.getContext(true);
        context.txCounter = 0;
        context.txBuffer = bufferSize;
    }

    public int getMaxBufferSize() {
        return this.getContext((boolean)true).txBuffer;
    }

    public int getCurrentBufferSize() {
        return this.getContext((boolean)true).txCounter;
    }

    protected void saveIndexConfiguration() {
        this.getRawGraph().getMetadata().getIndexManager().getConfiguration().save();
    }

    protected void autoStartTransaction() {
        OrientGraphContext context = this.getContext(true);
        if (context.txBuffer > 0 && (context.rawGraph.getTransaction() instanceof OTransactionNoTx || context.rawGraph.getTransaction().getStatus() != OTransaction.TXSTATUS.BEGUN)) {
            context.rawGraph.begin();
        }
    }

    protected void autoStopTransaction(TransactionalGraph.Conclusion conclusion) {
        OrientGraphContext context = this.getContext(true);
        if (context.txBuffer > 0) {
            ++context.txCounter;
            if (conclusion == TransactionalGraph.Conclusion.FAILURE) {
                OGraphDatabase db = this.getRawGraph();
                db.rollback();
                context.txCounter = 0;
            } else if (context.txCounter % context.txBuffer == 0) {
                OGraphDatabase db = this.getRawGraph();
                db.commit();
                context.txCounter = 0;
            }
        }
    }

    protected OrientGraphContext getContext(boolean create) {
        OrientGraphContext context = threadContext.get();
        if (context == null && create) {
            context = this.openOrCreate(false);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrientGraphContext openOrCreate(boolean createDefaultIndices) {
        if (this.url == null) {
            throw new IllegalStateException("Database is closed");
        }
        OrientGraph orientGraph = this;
        synchronized (orientGraph) {
            OrientGraphContext context = threadContext.get();
            if (context != null) {
                this.removeContext();
            }
            context = new OrientGraphContext();
            threadContext.set(context);
            List<OrientGraphContext> list = contexts;
            synchronized (list) {
                contexts.add(context);
            }
            context.rawGraph = new OGraphDatabase(this.url);
            context.rawGraph.setUseCustomTypes(false);
            if (this.url.startsWith("remote:") || context.rawGraph.exists()) {
                context.rawGraph.open(this.username, this.password);
                ODocument indexConfiguration = context.rawGraph.getMetadata().getIndexManager().getConfiguration();
                if (indexConfiguration == null) {
                    this.createIndexConfiguration(context, createDefaultIndices);
                }
                for (OIndex idx : context.rawGraph.getMetadata().getIndexManager().getIndexes()) {
                    if (idx.getConfiguration().field("blueprintsIndexType") == null) continue;
                    this.loadIndex(idx);
                }
            } else {
                context.rawGraph.create();
                this.createIndexConfiguration(context, createDefaultIndices);
            }
            return context;
        }
    }

    private void createIndexConfiguration(OrientGraphContext context, boolean createDefaultIndices) {
        if (createDefaultIndices) {
            this.createAutomaticIndex("vertices", OrientVertex.class, null, new Parameter[0]);
            this.createAutomaticIndex("edges", OrientEdge.class, null, new Parameter[0]);
        }
    }

    private OrientIndex<?> loadIndex(OIndex rawIndex) {
        OrientIndex index;
        String indexType = (String)rawIndex.getConfiguration().field("blueprintsIndexType");
        switch (Index.Type.valueOf((String)indexType.toUpperCase())) {
            case MANUAL: {
                index = new OrientIndex(this, rawIndex);
                this.getContext((boolean)true).manualIndices.put(index.getIndexName(), index);
                break;
            }
            case AUTOMATIC: {
                index = new OrientAutomaticIndex(this, rawIndex);
                this.getContext((boolean)true).autoIndices.put(index.getIndexName(), (OrientAutomaticIndex)index);
                break;
            }
            default: {
                throw new IllegalArgumentException("Index type '" + indexType + "' is not supported. Supported indicies: MANUAL, AUTOMATIC");
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContext() {
        OrientGraphContext context = this.getContext(false);
        if (context != null) {
            context.rawGraph.commit();
            context.rawGraph.close();
            for (Index<? extends Element> idx : this.getIndices()) {
                ((OrientIndex)idx).close();
            }
            context.manualIndices.clear();
            context.autoIndices.clear();
            List<OrientGraphContext> list = contexts;
            synchronized (list) {
                contexts.remove(context);
            }
            threadContext.set(null);
        }
    }
}

