/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.orientdb;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexTxAwareMultiValue;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.pgm.CloseableSequence;
import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.WrappingCloseableSequence;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientEdge;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientElement;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientGraph;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientVertex;
import com.tinkerpop.blueprints.pgm.impls.orientdb.util.OrientElementSequence;
import java.util.Collection;
import java.util.Collections;

public class OrientIndex<T extends OrientElement>
implements Index<T> {
    private static final String VERTEX = "Vertex";
    private static final String EDGE = "Edge";
    protected static final String CONFIG_TYPE = "blueprintsIndexType";
    protected static final String CONFIG_CLASSNAME = "blueprintsIndexClass";
    protected static final String SEPARATOR = "!=!";
    protected OrientGraph graph;
    protected OIndex underlying;
    protected Class<? extends Element> indexClass;

    OrientIndex(OrientGraph graph, String indexName, Class<? extends Element> indexClass, Index.Type indexType, OType iType) {
        this.graph = graph;
        this.indexClass = indexClass;
        this.create(indexName, this.indexClass, indexType, iType);
    }

    public OrientIndex(OrientGraph orientGraph, OIndex rawIndex) {
        this.graph = orientGraph;
        this.underlying = new OIndexTxAwareMultiValue((ODatabaseRecord)orientGraph.getRawGraph(), rawIndex);
        this.load(rawIndex.getConfiguration());
    }

    public OIndex getRawIndex() {
        return this.underlying;
    }

    public String getIndexName() {
        return this.underlying.getName();
    }

    public Class<T> getIndexClass() {
        return this.indexClass;
    }

    public Index.Type getIndexType() {
        return Index.Type.MANUAL;
    }

    public void put(String key, Object value, T element) {
        String keyTemp = key + SEPARATOR + value;
        ODocument doc = ((OrientElement)element).getRawElement();
        if (!doc.getIdentity().isValid()) {
            doc.save();
        }
        this.graph.autoStartTransaction();
        try {
            this.underlying.put((Object)keyTemp, (OIdentifiable)doc);
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (RuntimeException e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public CloseableSequence<T> get(String key, Object value) {
        String keyTemp = key + SEPARATOR + value;
        Collection records = (Collection)this.underlying.get((Object)keyTemp);
        if (records.isEmpty()) {
            return new WrappingCloseableSequence(Collections.emptySet());
        }
        return new OrientElementSequence(this.graph, records.iterator());
    }

    public long count(String key, Object value) {
        String keyTemp = key + SEPARATOR + value;
        Collection records = (Collection)this.underlying.get((Object)keyTemp);
        return records.size();
    }

    public void remove(String key, Object value, T element) {
        String keyTemp = key + SEPARATOR + value;
        this.graph.autoStartTransaction();
        try {
            this.underlying.remove((Object)keyTemp, (OIdentifiable)((OrientElement)element).getRawElement());
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (RuntimeException e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void removeBasic(String key, T element) {
        this.underlying.remove((Object)key, (OIdentifiable)((OrientElement)element).getRawElement());
    }

    protected void putBasic(String key, T element) {
        this.underlying.put((Object)key, (OIdentifiable)((OrientElement)element).getRawElement());
    }

    public String toString() {
        return StringFactory.indexString((Index)this);
    }

    protected void removeElement(T vertex) {
        this.graph.autoStartTransaction();
        ODocument vertexDoc = ((OrientElement)vertex).getRawElement();
        this.underlying.remove((OIdentifiable)vertexDoc);
        this.graph.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
    }

    private void create(String indexName, Class<? extends Element> indexClass, Index.Type indexType, OType iKeyType) {
        this.indexClass = indexClass;
        if (iKeyType == null) {
            iKeyType = OType.STRING;
        }
        this.underlying = new OIndexTxAwareMultiValue((ODatabaseRecord)this.graph.getRawGraph(), this.graph.getRawGraph().getMetadata().getIndexManager().createIndex(indexName, OClass.INDEX_TYPE.NOTUNIQUE.toString(), (OIndexDefinition)new OSimpleKeyIndexDefinition(new OType[]{iKeyType}), null, null));
        String className = Vertex.class.isAssignableFrom(indexClass) ? VERTEX : (Edge.class.isAssignableFrom(indexClass) ? EDGE : indexClass.getName());
        this.underlying.getConfiguration().field(CONFIG_CLASSNAME, (Object)className);
        this.underlying.getConfiguration().field(CONFIG_TYPE, (Object)indexType.toString());
    }

    private void load(ODocument indexConfiguration) {
        String indexClassName = (String)indexConfiguration.field(CONFIG_CLASSNAME);
        if (VERTEX.equals(indexClassName)) {
            this.indexClass = OrientVertex.class;
        } else if (EDGE.equals(indexClassName)) {
            this.indexClass = OrientEdge.class;
        } else {
            try {
                this.indexClass = Class.forName(indexClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Index class '" + indexClassName + "' is not registered. Supported ones: Vertex, Edge and custom class that extends them");
            }
        }
    }

    public void close() {
        this.underlying = null;
        this.graph = null;
    }
}

