/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.orientdb;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Query;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.DefaultQuery;
import com.tinkerpop.blueprints.pgm.impls.MultiIterable;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientElement;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientGraph;
import com.tinkerpop.blueprints.pgm.impls.orientdb.util.OrientElementSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class OrientVertex
extends OrientElement
implements Vertex {
    public OrientVertex() {
        super(null, new ODocument());
    }

    public OrientVertex(OrientGraph rawGraph, ODocument rawVertex) {
        super(rawGraph, rawVertex);
    }

    public Iterable<Edge> getOutEdges(String ... labels) {
        if (this.rawElement == null) {
            return Collections.emptyList();
        }
        if (labels.length == 0) {
            return new OrientElementSequence(this.graph, this.graph.getRawGraph().getOutEdges((OIdentifiable)this.rawElement, null).iterator());
        }
        if (labels.length == 1) {
            return new OrientElementSequence(this.graph, this.graph.getRawGraph().getOutEdges((OIdentifiable)this.rawElement, labels[0]).iterator());
        }
        ArrayList edges = new ArrayList();
        for (String label : labels) {
            edges.add(new OrientElementSequence(this.graph, this.graph.getRawGraph().getOutEdges((OIdentifiable)this.rawElement, label).iterator()));
        }
        return new MultiIterable(edges);
    }

    public Iterable<Edge> getInEdges(String ... labels) {
        if (this.rawElement == null) {
            return Collections.emptyList();
        }
        if (labels.length == 0) {
            return new OrientElementSequence(this.graph, this.graph.getRawGraph().getInEdges((OIdentifiable)this.rawElement, null).iterator());
        }
        if (labels.length == 1) {
            return new OrientElementSequence(this.graph, this.graph.getRawGraph().getInEdges((OIdentifiable)this.rawElement, labels[0]).iterator());
        }
        ArrayList edges = new ArrayList();
        for (String label : labels) {
            edges.add(new OrientElementSequence(this.graph, this.graph.getRawGraph().getInEdges((OIdentifiable)this.rawElement, label).iterator()));
        }
        return new MultiIterable(edges);
    }

    public Query query() {
        return new DefaultQuery((Vertex)this);
    }

    @Override
    public Set<String> getPropertyKeys() {
        Set<String> set = super.getPropertyKeys();
        if (set.size() > 0) {
            set.remove("in");
            set.remove("out");
        }
        return set;
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }
}

