/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.orientdb.util;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.pgm.CloseableSequence;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientEdge;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientElement;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientGraph;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientVertex;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OrientElementSequence<T extends Element>
implements CloseableSequence<T> {
    private final Iterator<?> rawIterator;
    private final OrientGraph graph;

    public OrientElementSequence(OrientGraph graph, Iterator<?> rawIterator) {
        this.graph = graph;
        this.rawIterator = rawIterator;
    }

    public boolean hasNext() {
        return this.rawIterator.hasNext();
    }

    public T next() {
        OrientElement currentElement = null;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object current = this.rawIterator.next();
        if (null == current) {
            throw new NoSuchElementException();
        }
        if (current instanceof OIdentifiable) {
            current = ((OIdentifiable)current).getRecord();
        }
        if (current instanceof ODocument) {
            ODocument currentDocument = (ODocument)current;
            if (currentDocument.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                currentDocument.load();
            }
            currentElement = currentDocument.getSchemaClass().isSubClassOf(this.graph.getRawGraph().getEdgeBaseClass()) ? new OrientEdge(this.graph, currentDocument) : new OrientVertex(this.graph, currentDocument);
        }
        return (T)currentElement;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Iterator<T> iterator() {
        return this;
    }

    public void close() {
    }
}

