/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.object.db.OObjectNotDetachedException;
import com.orientechnologies.orient.object.dictionary.ODictionaryWrapper;
import com.orientechnologies.orient.object.enhancement.OObjectEntityEnhancer;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.enhancement.OObjectProxyMethodHandler;
import com.orientechnologies.orient.object.entity.OObjectEntityClassHandler;
import com.orientechnologies.orient.object.iterator.OObjectIteratorClass;
import com.orientechnologies.orient.object.iterator.OObjectIteratorCluster;
import com.orientechnologies.orient.object.serialization.OObjectSerializerHelper;
import java.util.ArrayList;
import java.util.Set;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectDatabaseTx
extends ODatabasePojoAbstract<Object>
implements ODatabaseObject,
OUserObject2RecordHandler {
    public static final String TYPE = "object";
    protected ODictionary<Object> dictionary;
    protected OEntityManager entityManager;
    protected boolean saveOnlyDirty;
    protected boolean lazyLoading;

    public OObjectDatabaseTx(String iURL) {
        super(new ODatabaseDocumentTx(iURL));
        ((ODatabaseDocumentTx)this.underlying).setDatabaseOwner(this);
        this.init();
    }

    @Override
    public <T> T newInstance(Class<T> iType) {
        return (T)this.newInstance(iType.getSimpleName(), null, new Object[0]);
    }

    public <T> T newInstance(Class<T> iType, Object ... iArgs) {
        return (T)this.newInstance(iType.getSimpleName(), null, iArgs);
    }

    @Override
    public <RET> RET newInstance(String iClassName) {
        return this.newInstance(iClassName, null, new Object[0]);
    }

    @Override
    public <THISDB extends ODatabase> THISDB open(String iUserName, String iUserPassword) {
        super.open(iUserName, iUserPassword);
        this.entityManager.registerEntityClass(OUser.class);
        this.entityManager.registerEntityClass(ORole.class);
        return (THISDB)this;
    }

    public <RET> RET newInstance(String iClassName, Object iEnclosingClass, Object ... iArgs) {
        this.checkSecurity("database.class", ORole.PERMISSION_CREATE, (Object)iClassName);
        try {
            Object enhanced = OObjectEntityEnhancer.getInstance().getProxiedInstance(this.entityManager.getEntityClass(iClassName), iEnclosingClass, ((ODatabaseDocumentTx)this.underlying).newInstance(iClassName), iArgs);
            return (RET)enhanced;
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on creating object of class " + iClassName, (Throwable)e, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    public <RET> RET newInstance(String iClassName, Object iEnclosingClass, ODocument iDocument, Object ... iArgs) {
        this.checkSecurity("database.class", ORole.PERMISSION_CREATE, (Object)iClassName);
        try {
            Object enhanced = OObjectEntityEnhancer.getInstance().getProxiedInstance(this.entityManager.getEntityClass(iClassName), iEnclosingClass, iDocument, iArgs);
            return (RET)enhanced;
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on creating object of class " + iClassName, (Throwable)e, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    public <RET> OObjectIteratorClass<RET> browseClass(Class<RET> iClusterClass) {
        return this.browseClass(iClusterClass, true);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(Class<RET> iClusterClass, boolean iPolymorphic) {
        if (iClusterClass == null) {
            return null;
        }
        return this.browseClass(iClusterClass.getSimpleName(), iPolymorphic);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(String iClassName) {
        return this.browseClass(iClassName, true);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(String iClassName, boolean iPolymorphic) {
        this.checkOpeness();
        this.checkSecurity("database.class", ORole.PERMISSION_READ, (Object)iClassName);
        return new OObjectIteratorClass(this, (ODatabaseRecordAbstract)this.getUnderlying().getUnderlying(), iClassName, iPolymorphic);
    }

    public <RET> OObjectIteratorCluster<RET> browseCluster(String iClusterName) {
        this.checkOpeness();
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        return new OObjectIteratorCluster(this, (ODatabaseRecordAbstract)this.getUnderlying().getUnderlying(), this.getClusterIdByName(iClusterName));
    }

    @Override
    public <RET> RET load(Object iPojo) {
        return this.load(iPojo, (String)null);
    }

    public <RET> RET reload(Object iPojo) {
        return this.reload(iPojo, (String)null, true);
    }

    @Override
    public <RET> RET reload(Object iPojo, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpeness();
        if (iPojo == null) {
            return null;
        }
        ODocument record = this.getRecordByUserObject(iPojo, true);
        ((ODatabaseDocumentTx)this.underlying).reload(record, iFetchPlan, iIgnoreCache);
        iPojo = this.stream2pojo(record, iPojo, iFetchPlan, true);
        return (RET)iPojo;
    }

    @Override
    public <RET> RET load(Object iPojo, String iFetchPlan) {
        return this.load(iPojo, iFetchPlan, false);
    }

    @Override
    public <RET> RET load(Object iPojo, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpeness();
        if (iPojo == null) {
            return null;
        }
        ODocument record = this.getRecordByUserObject(iPojo, true);
        try {
            record.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(record, iFetchPlan, iIgnoreCache);
            Object object = this.stream2pojo(record, iPojo, iFetchPlan);
            return (RET)object;
        }
        finally {
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
    }

    @Override
    public <RET> RET load(ORID iRecordId) {
        return this.load(iRecordId, (String)null);
    }

    @Override
    public <RET> RET load(ORID iRecordId, String iFetchPlan) {
        return this.load(iRecordId, iFetchPlan, false);
    }

    @Override
    public <RET> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpeness();
        if (iRecordId == null) {
            return null;
        }
        ODocument record = (ODocument)this.rid2Records.get(iRecordId);
        if (record == null && (record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(iRecordId, iFetchPlan, iIgnoreCache)) == null) {
            return null;
        }
        return (RET)OObjectEntityEnhancer.getInstance().getProxiedInstance(record.getClassName(), this.entityManager, record, new Object[0]);
    }

    @Override
    public <RET> RET save(Object iContent) {
        return this.save(iContent, (String)null, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, (ORecordCallback<? extends Number>)null);
    }

    @Override
    public <RET> RET save(Object iContent, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        return this.save(iContent, (String)null, iMode, iCallback);
    }

    @Override
    public <RET> RET save(Object iPojo, String iClusterName) {
        return this.save(iPojo, iClusterName, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, (ORecordCallback<? extends Number>)null);
    }

    @Override
    public <RET> RET save(Object iPojo, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        this.checkOpeness();
        if (iPojo == null) {
            return (RET)iPojo;
        }
        if (OMultiValue.isMultiValue((Object)iPojo)) {
            for (Object pojo : OMultiValue.getMultiValueIterable((Object)iPojo)) {
                this.save(pojo, iClusterName);
            }
            return (RET)iPojo;
        }
        ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
        Object proxiedObject = OObjectEntitySerializer.serializeObject(iPojo, this);
        ODocument record = this.getRecordByUserObject(proxiedObject, true);
        try {
            record.setInternalStatus(ORecordElement.STATUS.MARSHALLING);
            if (!this.saveOnlyDirty || record.isDirty()) {
                ((ODatabaseDocumentTx)this.underlying).save(record, iClusterName, iMode, iCallback);
                this.registerUserObject(proxiedObject, record);
            }
        }
        finally {
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return (RET)proxiedObject;
    }

    public ODatabaseObject delete(Object iPojo) {
        this.checkOpeness();
        if (iPojo == null) {
            return this;
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            ORecordId rid = OObjectSerializerHelper.getObjectID(this, iPojo);
            if (rid == null) {
                throw new OObjectNotDetachedException("Cannot retrieve the object's ID for '" + iPojo + "' because has not been detached");
            }
            record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(rid);
        }
        ((ODatabaseDocumentTx)this.underlying).delete(record);
        if (this.getTransaction() instanceof OTransactionNoTx) {
            this.unregisterPojo(iPojo, record);
        }
        return this;
    }

    @Override
    public long countClass(String iClassName) {
        this.checkOpeness();
        return ((ODatabaseDocumentTx)this.underlying).countClass(iClassName);
    }

    public long countClass(Class<?> iClass) {
        this.checkOpeness();
        return ((ODatabaseDocumentTx)this.underlying).countClass(iClass.getSimpleName());
    }

    @Override
    public ODictionary<Object> getDictionary() {
        this.checkOpeness();
        if (this.dictionary == null) {
            this.dictionary = new ODictionaryWrapper(this);
        }
        return this.dictionary;
    }

    @Override
    public ODatabasePojoAbstract<Object> commit() {
        try {
            ((ODatabaseRecordTx)((ODatabaseDocumentTx)this.underlying).getUnderlying()).commit();
            if (this.getTransaction().getAllRecordEntries() != null) {
                Object pojo = null;
                for (ORecordOperation oRecordOperation : this.getTransaction().getAllRecordEntries()) {
                    switch (oRecordOperation.type) {
                        case 3: {
                            this.rid2Records.put(oRecordOperation.getRecord().getIdentity(), (ODocument)oRecordOperation.getRecord());
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            this.unregisterPojo((Object)pojo, (ODocument)oRecordOperation.getRecord());
                        }
                    }
                }
            }
        }
        finally {
            this.getTransaction().close();
        }
        return this;
    }

    @Override
    public ODatabasePojoAbstract<Object> rollback() {
        try {
            ArrayList<ORecordOperation> newEntries;
            if (this.getTransaction().getCurrentRecordEntries() != null) {
                newEntries = new ArrayList<ORecordOperation>();
                for (ORecordOperation oRecordOperation : this.getTransaction().getCurrentRecordEntries()) {
                    if (oRecordOperation.type != 3) continue;
                    newEntries.add(oRecordOperation);
                }
            } else {
                newEntries = null;
            }
            ((ODatabaseRecordTx)((ODatabaseDocumentTx)this.underlying).getUnderlying()).rollback();
            if (this.getTransaction().getCurrentRecordEntries() != null) {
                for (ORecordOperation oRecordOperation : this.getTransaction().getCurrentRecordEntries()) {
                    this.rid2Records.remove(oRecordOperation.getRecord().getIdentity());
                }
            }
            if (this.getTransaction().getAllRecordEntries() != null) {
                for (ORecordOperation oRecordOperation : this.getTransaction().getAllRecordEntries()) {
                    this.rid2Records.remove(oRecordOperation.getRecord().getIdentity());
                }
            }
        }
        finally {
            this.getTransaction().close();
        }
        return this;
    }

    @Override
    public OEntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public ODatabaseDocument getUnderlying() {
        return (ODatabaseDocument)this.underlying;
    }

    @Override
    public int getVersion(Object iPojo) {
        this.checkOpeness();
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record != null) {
            return record.getVersion();
        }
        return OObjectSerializerHelper.getObjectVersion(iPojo);
    }

    @Override
    public ORID getIdentity(Object iPojo) {
        this.checkOpeness();
        if (iPojo instanceof OIdentifiable) {
            return ((OIdentifiable)iPojo).getIdentity();
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record != null) {
            return record.getIdentity();
        }
        return OObjectSerializerHelper.getObjectID(this, iPojo);
    }

    public boolean isSaveOnlyDirty() {
        return this.saveOnlyDirty;
    }

    public void setSaveOnlyDirty(boolean saveOnlyDirty) {
        this.saveOnlyDirty = saveOnlyDirty;
    }

    @Override
    public Object newInstance() {
        this.checkOpeness();
        return new ODocument();
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(String iResource, byte iOperation) {
        return ((ODatabaseDocumentTx)this.underlying).checkSecurity(iResource, iOperation);
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(String iResource, int iOperation, Object iResourceSpecific) {
        return ((ODatabaseDocumentTx)this.underlying).checkSecurity(iResource, iOperation, iResourceSpecific);
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(String iResource, int iOperation, Object ... iResourcesSpecific) {
        return ((ODatabaseDocumentTx)this.underlying).checkSecurity(iResource, iOperation, iResourcesSpecific);
    }

    @Override
    public ODocument pojo2Stream(Object iPojo, ODocument iRecord) {
        if (iPojo instanceof ProxyObject) {
            return ((OObjectProxyMethodHandler)((ProxyObject)iPojo).getHandler()).getDoc();
        }
        return OObjectSerializerHelper.toStream(iPojo, iRecord, this.getEntityManager(), this.getMetadata().getSchema().getClass(iPojo.getClass().getSimpleName()), this, this, this.saveOnlyDirty);
    }

    @Override
    public Object stream2pojo(ODocument iRecord, Object iPojo, String iFetchPlan) {
        return this.stream2pojo(iRecord, iPojo, iFetchPlan, false);
    }

    public Object stream2pojo(ODocument iRecord, Object iPojo, String iFetchPlan, boolean iReload) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            iRecord = (ODocument)iRecord.load();
        }
        if (iReload) {
            if (iPojo != null) {
                if (iPojo instanceof Proxy) {
                    ((OObjectProxyMethodHandler)((ProxyObject)iPojo).getHandler()).setDoc(iRecord);
                    return iPojo;
                }
                return OObjectEntityEnhancer.getInstance().getProxiedInstance(iPojo.getClass(), iRecord, new Object[0]);
            }
            return OObjectEntityEnhancer.getInstance().getProxiedInstance(iRecord.getClassName(), this.entityManager, iRecord, new Object[0]);
        }
        if (!(iPojo instanceof Proxy)) {
            return OObjectEntityEnhancer.getInstance().getProxiedInstance(iPojo.getClass(), iRecord, new Object[0]);
        }
        return iPojo;
    }

    @Override
    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    @Override
    public void setLazyLoading(boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    protected void init() {
        this.entityManager = OEntityManager.getEntityManagerByDatabaseURL(this.getURL());
        this.entityManager.setClassHandler(OObjectEntityClassHandler.getInstance());
        this.saveOnlyDirty = OGlobalConfiguration.OBJECT_SAVE_ONLY_DIRTY.getValueAsBoolean();
        OObjectSerializerHelper.register();
        this.lazyLoading = true;
        if (!this.isClosed() && this.entityManager.getEntityClass(OUser.class.getSimpleName()) == null) {
            this.entityManager.registerEntityClass(OUser.class);
            this.entityManager.registerEntityClass(ORole.class);
        }
    }

    @Override
    public ODocument getRecordByUserObject(Object iPojo, boolean iCreateIfNotAvailable) {
        if (iPojo instanceof Proxy) {
            return OObjectEntitySerializer.getDocument((Proxy)iPojo);
        }
        return OObjectEntitySerializer.getDocument((Proxy)OObjectEntitySerializer.serializeObject(iPojo, this));
    }

    @Override
    public Object getUserObjectByRecord(ORecordInternal<?> iRecord, String iFetchPlan, boolean iCreate) {
        if (!(iRecord instanceof ODocument)) {
            return null;
        }
        ODocument record = (ODocument)this.rid2Records.get(iRecord.getIdentity());
        if (record == null) {
            record = (ODocument)iRecord;
        }
        Object pojo = OObjectEntityEnhancer.getInstance().getProxiedInstance(record.getClassName(), this.getEntityManager(), record, new Object[0]);
        return pojo;
    }

    @Override
    public void registerUserObject(Object iObject, ORecordInternal<?> iRecord) {
        ORID rid;
        if (!(iRecord instanceof ODocument)) {
            return;
        }
        ODocument doc = (ODocument)iRecord;
        if (this.retainObjects && (rid = iRecord.getIdentity()).isValid()) {
            this.rid2Records.put(rid, doc);
        }
    }

    @Override
    public void unregisterPojo(Object iObject, ODocument iRecord) {
        ORID rid;
        if (iRecord != null && (rid = iRecord.getIdentity()).isValid()) {
            this.rid2Records.remove(rid);
        }
    }
}

