/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.object.OLazyObjectListInterface;
import com.orientechnologies.orient.core.db.object.OLazyObjectMultivalueElement;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.OObjectLazyListIterator;
import com.orientechnologies.orient.object.enhancement.OObjectEntityEnhancer;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javassist.util.proxy.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectLazyList<TYPE>
implements OLazyObjectListInterface<TYPE>,
OLazyObjectMultivalueElement,
Serializable {
    private static final long serialVersionUID = -1665952780303555865L;
    private ORecord<?> sourceRecord;
    private final List<OIdentifiable> recordList;
    private final ArrayList<Object> list = new ArrayList();
    private String fetchPlan;
    private boolean converted = false;
    private boolean convertToRecord = true;

    public OObjectLazyList(ORecord<?> iSourceRecord, List<OIdentifiable> iRecordList) {
        this.sourceRecord = iSourceRecord;
        this.recordList = iRecordList;
        int i = 0;
        while (i < iRecordList.size()) {
            this.list.add(i, null);
            ++i;
        }
    }

    public OObjectLazyList(ORecord<?> iSourceRecord, List<OIdentifiable> iRecordList, Collection<? extends TYPE> iSourceList) {
        this.sourceRecord = iSourceRecord;
        this.recordList = iRecordList;
        int i = 0;
        while (i < iRecordList.size()) {
            this.list.add(i, null);
            ++i;
        }
        this.addAll(iSourceList);
    }

    @Override
    public Iterator<TYPE> iterator() {
        return new OObjectLazyListIterator(this, this.sourceRecord);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Proxy) {
            return this.recordList.contains(OObjectEntitySerializer.getDocument((Proxy)o));
        }
        if (o instanceof OIdentifiable) {
            return this.recordList.contains(o);
        }
        this.convertAll();
        return this.list.contains(o);
    }

    @Override
    public boolean add(TYPE element) {
        boolean dirty = false;
        if (element instanceof OIdentifiable) {
            if (this.converted) {
                this.converted = false;
            }
            if (this.recordList.add((OIdentifiable)element)) {
                this.setDirty();
                return true;
            }
        } else if (element instanceof Proxy) {
            dirty = this.recordList.add(OObjectEntitySerializer.getDocument((Proxy)element));
        } else {
            element = OObjectEntitySerializer.serializeObject(element, this.getDatabase());
            dirty = this.recordList.add(OObjectEntitySerializer.getDocument((Proxy)element));
        }
        if (dirty) {
            this.setDirty();
        }
        return this.list.add(element);
    }

    @Override
    public void add(int index, TYPE element) {
        this.setDirty();
        if (element instanceof OIdentifiable) {
            if (this.converted) {
                this.converted = false;
            }
            this.recordList.add(index, (OIdentifiable)element);
            return;
        }
        if (element instanceof Proxy) {
            this.recordList.add(OObjectEntitySerializer.getDocument((Proxy)element));
        } else {
            element = OObjectEntitySerializer.serializeObject(element, this.getDatabase());
            this.recordList.add(index, OObjectEntitySerializer.getDocument((Proxy)element));
        }
        this.list.add(index, element);
    }

    @Override
    public TYPE get(int index) {
        Object o = this.list.get(index);
        if (o == null) {
            OIdentifiable record = this.recordList.get(index);
            o = OObjectEntityEnhancer.getInstance().getProxiedInstance(((ODocument)record.getRecord()).getClassName(), this.getDatabase().getEntityManager(), (ODocument)record.getRecord(), new Object[0]);
            this.list.set(index, o);
        }
        return (TYPE)o;
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Proxy) {
            return this.recordList.indexOf(OObjectEntitySerializer.getDocument((Proxy)o));
        }
        if (o instanceof OIdentifiable) {
            return this.recordList.indexOf(o);
        }
        this.convertAll();
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Proxy) {
            return this.recordList.lastIndexOf(OObjectEntitySerializer.getDocument((Proxy)o));
        }
        if (o instanceof OIdentifiable) {
            return this.recordList.lastIndexOf(o);
        }
        this.convertAll();
        return this.list.lastIndexOf(o);
    }

    @Override
    public Object[] toArray() {
        this.convertAll();
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.convertAll();
        return this.list.toArray(a);
    }

    @Override
    public int size() {
        return this.recordList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.recordList.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        this.setDirty();
        if (o instanceof OIdentifiable) {
            int elementIndex = this.recordList.indexOf(o);
            if (this.indexLoaded(elementIndex)) {
                this.list.remove(elementIndex);
            }
            return this.recordList.remove(o);
        }
        if (o instanceof Proxy) {
            this.recordList.remove(OObjectEntitySerializer.getDocument((Proxy)o));
        }
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends TYPE> c) {
        boolean dirty = false;
        for (TYPE element : c) {
            boolean bl = dirty = this.add(element) || dirty;
        }
        if (dirty) {
            this.setDirty();
        }
        return dirty;
    }

    @Override
    public boolean addAll(int index, Collection<? extends TYPE> c) {
        for (TYPE element : c) {
            this.add(index, element);
            ++index;
        }
        if (c.size() > 0) {
            this.setDirty();
        }
        return c.size() > 0;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean dirty = true;
        for (Object o : c) {
            boolean bl = dirty = this.remove(o) || dirty;
        }
        if (dirty) {
            this.setDirty();
        }
        return dirty;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<TYPE> e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            this.remove(e);
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.setDirty();
        this.recordList.clear();
        this.list.clear();
    }

    @Override
    public TYPE set(int index, TYPE element) {
        if (element instanceof OIdentifiable) {
            if (this.converted) {
                this.converted = false;
            }
            this.recordList.set(index, (OIdentifiable)element);
        } else if (element instanceof Proxy) {
            this.recordList.set(index, OObjectEntitySerializer.getDocument((Proxy)element));
        } else {
            element = OObjectEntitySerializer.serializeObject(element, this.getDatabase());
            this.recordList.add(index, OObjectEntitySerializer.getDocument((Proxy)element));
        }
        this.setDirty();
        return (TYPE)this.list.set(index, element);
    }

    @Override
    public TYPE remove(int index) {
        OIdentifiable record = this.recordList.remove(index);
        Object element = this.indexLoaded(index) ? this.list.remove(index) : OObjectEntityEnhancer.getInstance().getProxiedInstance(((ODocument)record.getRecord()).getClassName(), this.getDatabase().getEntityManager(), (ODocument)record.getRecord(), new Object[0]);
        this.setDirty();
        return (TYPE)element;
    }

    @Override
    public ListIterator<TYPE> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<TYPE> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<TYPE> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public OObjectLazyList<TYPE> setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return this;
    }

    public boolean isConvertToRecord() {
        return this.convertToRecord;
    }

    @Override
    public void setConvertToRecord(boolean convertToRecord) {
        this.convertToRecord = convertToRecord;
    }

    @Override
    public boolean isConverted() {
        return this.converted;
    }

    @Override
    public void detach() {
        this.convertAll();
    }

    protected void convertAll() {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        int i = 0;
        while (i < this.size()) {
            this.convert(i);
            ++i;
        }
        this.converted = true;
    }

    public void setDirty() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    private void convert(int iIndex) {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        Object o = this.list.get(iIndex);
        if (o == null) {
            ODatabaseRecord database = (ODatabaseRecord)this.getDatabase().getUnderlying();
            o = this.recordList.get(iIndex);
            ODocument doc = o instanceof ORID ? (ODocument)database.load((ORID)o, this.fetchPlan) : (ODocument)o;
            this.list.set(iIndex, OObjectEntityEnhancer.getInstance().getProxiedInstance(doc.getClassName(), this.getDatabase().getEntityManager(), doc, new Object[0]));
        }
    }

    protected ODatabaseObject getDatabase() {
        return (ODatabaseObject)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner();
    }

    protected boolean indexLoaded(int iIndex) {
        return this.list.get(iIndex) != null;
    }

    public String toString() {
        return this.list.toString();
    }
}

