/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.object.db.OObjectLazyList;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectLazyListIterator<TYPE>
implements Iterator<TYPE>,
Serializable {
    private static final long serialVersionUID = 3714399452499077452L;
    private final ORecord<?> sourceRecord;
    private final OObjectLazyList<TYPE> list;
    private String fetchPlan;
    private int cursor = 0;
    private int lastRet = -1;

    public OObjectLazyListIterator(OObjectLazyList<TYPE> iSourceList, ORecord<?> iSourceRecord) {
        this.list = iSourceList;
        this.sourceRecord = iSourceRecord;
    }

    @Override
    public TYPE next() {
        return this.next(this.fetchPlan);
    }

    public TYPE next(String iFetchPlan) {
        TYPE value = this.list.get(this.cursor);
        this.lastRet = this.cursor++;
        return value;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.list.size();
    }

    @Override
    public void remove() {
        if (this.lastRet == -1) {
            throw new IllegalStateException();
        }
        try {
            this.list.remove(this.lastRet);
            if (this.lastRet < this.cursor) {
                --this.cursor;
            }
            this.lastRet = -1;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ConcurrentModificationException();
        }
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
    }
}

