/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.object.OLazyObjectMapInterface;
import com.orientechnologies.orient.core.db.object.OLazyObjectMultivalueElement;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectLazyMap<TYPE>
extends HashMap<Object, Object>
implements Serializable,
OLazyObjectMultivalueElement,
OLazyObjectMapInterface<TYPE> {
    private static final long serialVersionUID = -7071023580831419958L;
    private final ORecord<?> sourceRecord;
    private final Map<Object, OIdentifiable> underlying;
    private String fetchPlan;
    private boolean converted = false;
    private boolean convertToRecord = true;

    public OObjectLazyMap(ORecord<?> iSourceRecord, Map<Object, OIdentifiable> iRecordMap) {
        this.sourceRecord = iSourceRecord;
        this.underlying = iRecordMap;
        this.converted = iRecordMap.isEmpty();
    }

    public OObjectLazyMap(ORecord<?> iSourceRecord, Map<Object, OIdentifiable> iRecordMap, Map<Object, Object> iSourceMap) {
        this(iSourceRecord, iRecordMap);
        this.putAll(iSourceMap);
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public boolean containsKey(Object k) {
        return this.underlying.containsKey(k);
    }

    @Override
    public boolean containsValue(Object o) {
        if (o instanceof OIdentifiable) {
            return this.underlying.containsValue((OIdentifiable)o);
        }
        if (o instanceof Proxy) {
            return this.underlying.containsValue(OObjectEntitySerializer.getDocument((Proxy)o));
        }
        return super.containsValue(o);
    }

    @Override
    public Object put(Object iKey, Object e) {
        this.setDirty();
        if (e instanceof OIdentifiable) {
            this.converted = false;
            return this.underlying.put(iKey, (OIdentifiable)e);
        }
        this.underlying.put(iKey, this.getDatabase().getRecordByUserObject(e, true));
        return super.put(iKey, e);
    }

    @Override
    public Object remove(Object iKey) {
        this.underlying.remove((String)iKey);
        this.setDirty();
        return super.remove(iKey);
    }

    @Override
    public void clear() {
        this.converted = true;
        this.underlying.clear();
        super.clear();
        this.setDirty();
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public boolean isConvertToRecord() {
        return this.convertToRecord;
    }

    @Override
    public void setConvertToRecord(boolean convertToRecord) {
        this.convertToRecord = convertToRecord;
    }

    @Override
    public boolean isConverted() {
        return this.converted;
    }

    public OObjectLazyMap<TYPE> setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return this;
    }

    @Override
    public String toString() {
        return this.underlying.toString();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        this.convertAll();
        return super.entrySet();
    }

    @Override
    public Object get(Object iKey) {
        this.convert((String)iKey);
        return super.get(iKey);
    }

    @Override
    public Set<Object> keySet() {
        this.convertAll();
        return this.underlying.keySet();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> iMap) {
        for (Map.Entry<? extends Object, ? extends Object> e : iMap.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<Object> values() {
        this.convertAll();
        return super.values();
    }

    public void setDirty() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    public Map<Object, OIdentifiable> getUnderlying() {
        return this.underlying;
    }

    private void convert(String iKey) {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        if (super.containsKey(iKey)) {
            return;
        }
        super.put(iKey, this.getDatabase().getUserObjectByRecord((ORecordInternal)this.underlying.get(iKey), null));
    }

    @Override
    public void detach() {
        this.convertAll();
    }

    protected void convertAll() {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        for (Map.Entry<Object, OIdentifiable> e : this.underlying.entrySet()) {
            super.put(e.getKey(), this.getDatabase().getUserObjectByRecord((ORecordInternal)e.getValue(), null));
        }
        this.converted = true;
    }

    protected ODatabasePojoAbstract<TYPE> getDatabase() {
        return (ODatabasePojoAbstract)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner();
    }
}

