/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db.graph;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.graph.OGraphDatabaseMigration;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.OGraphException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.object.db.graph.OGraphEdge;
import com.orientechnologies.orient.object.db.graph.OGraphElement;
import com.orientechnologies.orient.object.db.graph.OGraphVertex;
import com.orientechnologies.orient.object.iterator.graph.OGraphVertexIterator;
import java.util.Collection;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ODatabaseGraphTx
extends ODatabasePojoAbstract<OGraphElement> {
    public ODatabaseGraphTx(String iURL) {
        super(new ODatabaseDocumentTx(iURL));
    }

    @Override
    public <THISDB extends ODatabase> THISDB open(String iUserName, String iUserPassword) {
        ((ODatabaseDocumentTx)this.underlying).open(iUserName, iUserPassword);
        this.checkForGraphSchema();
        return (THISDB)this;
    }

    @Override
    public <THISDB extends ODatabase> THISDB create() {
        ((ODatabaseDocumentTx)this.underlying).create();
        this.checkForGraphSchema();
        return (THISDB)this;
    }

    public OGraphVertex createVertex() {
        return new OGraphVertex(this);
    }

    public OGraphVertex createVertex(String iClassName) {
        return new OGraphVertex(this, iClassName);
    }

    public OGraphVertex getRoot(String iName) {
        ODocument doc = (ODocument)((ODatabaseDocumentTx)this.underlying).getDictionary().get(iName);
        if (doc != null) {
            return this.registerPojo(new OGraphVertex(this, doc));
        }
        return null;
    }

    public OGraphVertex getRoot(String iName, String iFetchPlan) {
        return this.registerPojo(new OGraphVertex(this, (ODocument)((ODatabaseDocumentTx)this.underlying).getDictionary().get(iName), iFetchPlan));
    }

    public ODatabaseGraphTx setRoot(String iName, OGraphVertex iNode) {
        ((ODatabaseDocumentTx)this.underlying).getDictionary().put(iName, iNode.getDocument());
        return this;
    }

    @Override
    public ODictionary<OGraphElement> getDictionary() {
        throw new UnsupportedOperationException("getDictionary()");
    }

    @Override
    public OGraphElement newInstance() {
        return new OGraphVertex(this);
    }

    @Override
    public OGraphElement load(OGraphElement iObject) {
        if (iObject != null) {
            iObject.load();
        }
        return iObject;
    }

    @Override
    public OGraphElement load(OGraphElement iObject, String iFetchPlan) {
        if (iObject != null) {
            iObject.load(iFetchPlan);
        }
        return iObject;
    }

    @Override
    public OGraphElement load(OGraphElement iObject, String iFetchPlan, boolean iIgnoreCache) {
        if (iObject != null) {
            iObject.load(iFetchPlan, iIgnoreCache);
        }
        return iObject;
    }

    public void reload(OGraphElement iObject) {
        if (iObject != null) {
            iObject.reload();
        }
    }

    @Override
    public OGraphElement reload(OGraphElement iObject, String iFetchPlan, boolean iIgnoreCache) {
        if (iObject != null) {
            iObject.reload(iFetchPlan, iIgnoreCache);
        }
        return iObject;
    }

    @Override
    public OGraphElement load(ORID iRecordId) {
        return this.load(iRecordId, (String)null);
    }

    @Override
    public OGraphElement load(ORID iRecordId, String iFetchPlan) {
        return this.load(iRecordId, iFetchPlan, false);
    }

    @Override
    public OGraphElement load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        ODocument doc = this.loadAsDocument(iRecordId, iFetchPlan, iIgnoreCache);
        if (doc == null) {
            return null;
        }
        return this.newInstance(doc.getClassName()).setDocument(doc);
    }

    public ODocument loadAsDocument(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        if (iRecordId == null) {
            return null;
        }
        ODocument doc = this.getRecordById(iRecordId);
        if (doc == null && (doc = (ODocument)((ODatabaseDocumentTx)this.underlying).load(iRecordId, iFetchPlan, iIgnoreCache)) == null) {
            return null;
        }
        OFetchHelper.checkFetchPlanValid(iFetchPlan);
        if (doc.getClassName() == null) {
            throw new OGraphException("The document loaded has no class, while it should be a OGraphVertex, OGraphEdge or any subclass of its. Record: " + doc);
        }
        return doc;
    }

    @Override
    public <RET extends OGraphElement> RET save(OGraphElement iObject) {
        ((ODatabaseDocumentTx)this.underlying).save(iObject.getDocument());
        return (RET)iObject;
    }

    @Override
    public <RET extends OGraphElement> RET save(OGraphElement iObject, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        ((ODatabaseDocumentTx)this.underlying).save(iObject.getDocument(), iMode, iCallback);
        return (RET)iObject;
    }

    @Override
    public <RET extends OGraphElement> RET save(OGraphElement iObject, String iClusterName) {
        ((ODatabaseDocumentTx)this.underlying).save(iObject.getDocument(), iClusterName);
        return (RET)iObject;
    }

    @Override
    public <RET extends OGraphElement> RET save(OGraphElement iObject, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        ((ODatabaseDocumentTx)this.underlying).save(iObject.getDocument(), iClusterName, iMode, iCallback);
        return (RET)iObject;
    }

    @Override
    public ODatabaseComplex<OGraphElement> delete(OGraphElement iObject) {
        iObject.getDocument().delete();
        this.unregisterPojo(iObject, iObject.getDocument());
        return this;
    }

    public OGraphVertexIterator browseVertexes() {
        return new OGraphVertexIterator(this, true);
    }

    public OGraphVertexIterator browseVertexes(boolean iPolymorphic) {
        return new OGraphVertexIterator(this, iPolymorphic);
    }

    @Override
    public OGraphElement newInstance(String iClassName) {
        if (iClassName.equals(OGraphVertex.class.getSimpleName())) {
            return new OGraphVertex(this);
        }
        if (iClassName.equals(OGraphEdge.class.getSimpleName())) {
            return new OGraphEdge(this);
        }
        OClass cls = this.getMetadata().getSchema().getClass(iClassName);
        if (cls != null) {
            cls = cls.getSuperClass();
            while (cls != null) {
                if (cls.getName().equals(OGraphVertex.class.getSimpleName())) {
                    return new OGraphVertex(this, iClassName);
                }
                if (cls.getName().equals(OGraphEdge.class.getSimpleName())) {
                    return new OGraphEdge(this, iClassName);
                }
                cls = cls.getSuperClass();
            }
        }
        throw new OGraphException("Unrecognized class: " + iClassName);
    }

    public IdentityHashMap<ODocument, OGraphElement> getRecords2Objects() {
        return this.records2Objects;
    }

    public void removeCachedElements(Collection<OGraphElement> iElements) {
        for (OGraphElement e : iElements) {
            this.records2Objects.remove(e.getDocument());
            this.rid2Records.remove(e.getDocument().getIdentity());
            this.objects2Records.remove(System.identityHashCode(e));
        }
    }

    private OGraphVertex registerPojo(OGraphVertex iVertex) {
        this.registerUserObject(iVertex, iVertex.getDocument());
        return iVertex;
    }

    private void checkForGraphSchema() {
        OClass vertex = ((ODatabaseDocumentTx)this.underlying).getMetadata().getSchema().getClass("OGraphVertex");
        OClass edge = ((ODatabaseDocumentTx)this.underlying).getMetadata().getSchema().getClass("OGraphEdge");
        if (vertex == null) {
            vertex = ((ODatabaseDocumentTx)this.underlying).getMetadata().getSchema().createClass("OGraphVertex", ((ODatabaseDocumentTx)this.underlying).addPhysicalCluster("OGraphVertex"));
            edge = ((ODatabaseDocumentTx)this.underlying).getMetadata().getSchema().createClass("OGraphEdge", ((ODatabaseDocumentTx)this.underlying).addPhysicalCluster("OGraphEdge"));
            edge.createProperty("in", OType.LINK, vertex);
            edge.createProperty("out", OType.LINK, vertex);
            vertex.createProperty("in", OType.LINKSET, edge);
            vertex.createProperty("out", OType.LINKSET, edge);
        } else if (vertex.existsProperty("outEdges")) {
            OGraphDatabaseMigration.migrate((OGraphDatabase)new OGraphDatabase(this.getURL()).open("admin", "admin"));
        }
    }

    @Override
    public ODocument pojo2Stream(OGraphElement iPojo, ODocument record) {
        return record;
    }

    @Override
    public Object stream2pojo(ODocument record, Object iPojo, String iFetchPlan) {
        ((OGraphElement)iPojo).setDocument(record);
        return iPojo;
    }

    @Override
    public void drop() {
        ((ODatabaseDocumentTx)this.underlying).drop();
    }

    @Override
    public String getType() {
        return "oldgraph";
    }

    @Override
    public long countClass(String iClassName) {
        return ((ODatabaseDocumentTx)this.underlying).countClass(iClassName);
    }
}

