/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enhancement;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.reflection.OReflectionHelper;
import com.orientechnologies.orient.core.annotation.OAccess;
import com.orientechnologies.orient.core.annotation.OAfterDeserialization;
import com.orientechnologies.orient.core.annotation.OAfterSerialization;
import com.orientechnologies.orient.core.annotation.OBeforeDeserialization;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.annotation.ODocumentInstance;
import com.orientechnologies.orient.core.annotation.OId;
import com.orientechnologies.orient.core.annotation.OVersion;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.object.db.OObjectLazyMap;
import com.orientechnologies.orient.object.enhancement.OObjectProxyMethodHandler;
import com.orientechnologies.orient.object.serialization.OObjectSerializationThreadLocal;
import com.orientechnologies.orient.object.serialization.OObjectSerializerHelper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectEntitySerializer {
    private static final Set<Class<?>> classes = new HashSet();
    private static final HashMap<Class<?>, List<String>> embeddedFields = new HashMap();
    private static final HashMap<Class<?>, List<String>> directAccessFields = new HashMap();
    private static final HashMap<Class<?>, Field> boundDocumentFields = new HashMap();
    private static final HashMap<Class<?>, List<String>> transientFields = new HashMap();
    private static final HashMap<Class<?>, Map<Field, Class<?>>> serializedFields = new HashMap();
    private static final HashMap<Class<?>, Field> fieldIds = new HashMap();
    private static final HashMap<Class<?>, Field> fieldVersions = new HashMap();
    private static final HashMap<String, Method> callbacks = new HashMap();

    public static <T> T serializeObject(T o, ODatabaseObject db) {
        if (o instanceof Proxy) {
            return o;
        }
        Proxy proxiedObject = (Proxy)db.newInstance(o.getClass());
        try {
            return OObjectEntitySerializer.toStream(o, proxiedObject, db);
        }
        catch (IllegalArgumentException e) {
            throw new OSerializationException("Error serializing object of class " + o.getClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new OSerializationException("Error serializing object of class " + o.getClass(), e);
        }
    }

    public static ODocument getDocument(Proxy proxiedObject) {
        return ((OObjectProxyMethodHandler)((ProxyObject)proxiedObject).getHandler()).getDoc();
    }

    public static ORID getRid(Proxy proxiedObject) {
        return OObjectEntitySerializer.getDocument(proxiedObject).getIdentity();
    }

    public static int getVersion(Proxy proxiedObject) {
        return OObjectEntitySerializer.getDocument(proxiedObject).getVersion();
    }

    public static boolean isTransientField(Class<?> iClass, String iField) {
        if (!classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        boolean isTransientField = false;
        Class<?> currentClass = iClass;
        while (currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && !isTransientField) {
            List<String> classEmbeddedFields = transientFields.get(iClass);
            isTransientField = classEmbeddedFields != null && classEmbeddedFields.contains(iField);
            currentClass = currentClass.getSuperclass();
        }
        return isTransientField;
    }

    public static boolean isEmbeddedField(Class<?> iClass, String iField) {
        if (!classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        boolean isEmbeddedField = false;
        Class<?> currentClass = iClass;
        while (currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && !isEmbeddedField) {
            List<String> classEmbeddedFields = embeddedFields.get(iClass);
            isEmbeddedField = classEmbeddedFields != null && classEmbeddedFields.contains(iField);
            currentClass = currentClass.getSuperclass();
        }
        return isEmbeddedField;
    }

    public static synchronized void registerClass(Class<?> iClass) {
        if (classes.contains(iClass)) {
            return;
        }
        if (ODatabaseRecordThreadLocal.INSTANCE.isDefined() && !ODatabaseRecordThreadLocal.INSTANCE.get().isClosed() && !ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchema().existsClass(iClass.getSimpleName())) {
            ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchema().createClass(iClass.getSimpleName());
        }
        Class<Object> currentClass = iClass;
        while (currentClass != Object.class) {
            classes.add(currentClass);
            Field[] fieldArray = currentClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                String fieldName = f.getName();
                int fieldModifier = f.getModifiers();
                if (!(Modifier.isStatic(fieldModifier) || Modifier.isNative(fieldModifier) || Modifier.isTransient(fieldModifier))) {
                    Object ann;
                    Class fieldType;
                    Object ann2;
                    if (fieldName.equals("this$0")) {
                        List<String> classTransientFields = transientFields.get(currentClass);
                        if (classTransientFields == null) {
                            classTransientFields = new ArrayList<String>();
                        }
                        classTransientFields.add(fieldName);
                        transientFields.put(currentClass, classTransientFields);
                    }
                    if (OObjectSerializerHelper.jpaTransientClass != null && (ann2 = f.getAnnotation(OObjectSerializerHelper.jpaTransientClass)) != null) {
                        List<String> classTransientFields = transientFields.get(currentClass);
                        if (classTransientFields == null) {
                            classTransientFields = new ArrayList<String>();
                        }
                        classTransientFields.add(fieldName);
                        transientFields.put(currentClass, classTransientFields);
                    }
                    if (Collection.class.isAssignableFrom(fieldType = f.getType()) || fieldType.isArray() || Map.class.isAssignableFrom(fieldType)) {
                        fieldType = OReflectionHelper.getGenericMultivalueType((Field)f);
                    }
                    if (OObjectEntitySerializer.isToSerialize(fieldType)) {
                        Map<Field, Class<?>> serializeClass = serializedFields.get(currentClass);
                        if (serializeClass == null) {
                            serializeClass = new HashMap();
                        }
                        serializeClass.put(f, fieldType);
                        serializedFields.put(currentClass, serializeClass);
                    }
                    boolean directBinding = true;
                    if (f.getAnnotation(OAccess.class) == null || f.getAnnotation(OAccess.class).value() == OAccess.OAccessType.PROPERTY) {
                        directBinding = true;
                    } else if (OObjectSerializerHelper.jpaAccessClass != null && (ann = f.getAnnotation(OObjectSerializerHelper.jpaAccessClass)) != null) {
                        directBinding = true;
                    }
                    if (directBinding) {
                        List<String> classDirectAccessFields = directAccessFields.get(currentClass);
                        if (classDirectAccessFields == null) {
                            classDirectAccessFields = new ArrayList<String>();
                        }
                        classDirectAccessFields.add(fieldName);
                        directAccessFields.put(currentClass, classDirectAccessFields);
                    }
                    if (f.getAnnotation(ODocumentInstance.class) != null) {
                        boundDocumentFields.put(currentClass, f);
                    }
                    boolean idFound = false;
                    if (f.getAnnotation(OId.class) != null) {
                        fieldIds.put(currentClass, f);
                        idFound = true;
                    } else if (OObjectSerializerHelper.jpaIdClass != null && f.getAnnotation(OObjectSerializerHelper.jpaIdClass) != null) {
                        fieldIds.put(currentClass, f);
                        idFound = true;
                    }
                    if (idFound) {
                        if (fieldType.isPrimitive()) {
                            OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' cannot be a literal to manage the Record Id", new Object[]{f.toString()});
                        } else if (!ORID.class.isAssignableFrom(fieldType) && fieldType != String.class && fieldType != Object.class && !Number.class.isAssignableFrom(fieldType)) {
                            OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' cannot be managed as type: %s", new Object[]{f.toString(), fieldType});
                        }
                    }
                    boolean vFound = false;
                    if (f.getAnnotation(OVersion.class) != null) {
                        fieldVersions.put(currentClass, f);
                        vFound = true;
                    } else if (OObjectSerializerHelper.jpaVersionClass != null && f.getAnnotation(OObjectSerializerHelper.jpaVersionClass) != null) {
                        fieldVersions.put(currentClass, f);
                        vFound = true;
                    }
                    if (vFound) {
                        if (fieldType.isPrimitive()) {
                            OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' cannot be a literal to manage the Version", new Object[]{f.toString()});
                        } else if (fieldType != String.class && fieldType != Object.class && !Number.class.isAssignableFrom(fieldType)) {
                            OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' cannot be managed as type: %s", new Object[]{f.toString(), fieldType});
                        }
                    }
                    if (OObjectSerializerHelper.jpaEmbeddedClass != null && f.getAnnotation(OObjectSerializerHelper.jpaEmbeddedClass) != null) {
                        List<String> classEmbeddedFields = embeddedFields.get(currentClass);
                        if (classEmbeddedFields == null) {
                            classEmbeddedFields = new ArrayList<String>();
                        }
                        classEmbeddedFields.add(fieldName);
                    }
                }
                ++n2;
            }
            OObjectEntitySerializer.registerCallbacks(currentClass);
            String iClassName = iClass.getSimpleName();
            currentClass = currentClass.getSuperclass();
            if (currentClass == null || currentClass.equals(ODocument.class)) {
                currentClass = Object.class;
            }
            if (ODatabaseRecordThreadLocal.INSTANCE.get() == null || ODatabaseRecordThreadLocal.INSTANCE.get().isClosed() || currentClass.equals(Object.class)) continue;
            OClass currentOClass = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchema().getClass(iClassName);
            OClass oSuperClass = !ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchema().existsClass(currentClass.getSimpleName()) ? ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchema().createClass(currentClass.getSimpleName()) : ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchema().getClass(currentClass.getSimpleName());
            if (currentOClass.getSuperClass() != null && currentOClass.getSuperClass().equals(oSuperClass)) continue;
            currentOClass.setSuperClass(oSuperClass);
        }
        if (ODatabaseRecordThreadLocal.INSTANCE.get() != null && !ODatabaseRecordThreadLocal.INSTANCE.get().isClosed()) {
            ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchema().save();
        }
    }

    public static boolean isSerializedType(Field iField) {
        Map<Field, Class<?>> serializerFields;
        if (!classes.contains(iField.getDeclaringClass())) {
            OObjectEntitySerializer.registerCallbacks(iField.getDeclaringClass());
        }
        return (serializerFields = serializedFields.get(iField.getDeclaringClass())) != null && serializerFields.get(iField) != null;
    }

    public static Class<?> getSerializedType(Field iField) {
        if (!classes.contains(iField.getDeclaringClass())) {
            OObjectEntitySerializer.registerCallbacks(iField.getDeclaringClass());
        }
        return serializedFields.get(iField.getDeclaringClass()) != null ? serializedFields.get(iField.getDeclaringClass()).get(iField) : null;
    }

    public static boolean isToSerialize(Class<?> type) {
        for (Class<?> classContext : OObjectSerializerHelper.serializerContexts.keySet()) {
            if (classContext == null || !classContext.isAssignableFrom(type)) continue;
            return true;
        }
        return OObjectSerializerHelper.serializerContexts.get(null) != null && OObjectSerializerHelper.serializerContexts.get(null).isClassBinded(type);
    }

    public static Object serializeFieldValue(Class<?> type, Object iFieldValue) {
        for (Class<?> classContext : OObjectSerializerHelper.serializerContexts.keySet()) {
            if (classContext == null || !classContext.isAssignableFrom(type)) continue;
            return OObjectSerializerHelper.serializerContexts.get(classContext).serializeFieldValue(type, iFieldValue);
        }
        if (OObjectSerializerHelper.serializerContexts.get(null) != null) {
            return OObjectSerializerHelper.serializerContexts.get(null).serializeFieldValue(type, iFieldValue);
        }
        return iFieldValue;
    }

    public static Object deserializeFieldValue(Class<?> type, Object iFieldValue) {
        for (Class<?> classContext : OObjectSerializerHelper.serializerContexts.keySet()) {
            if (classContext == null || !classContext.isAssignableFrom(type)) continue;
            return OObjectSerializerHelper.serializerContexts.get(classContext).unserializeFieldValue(type, iFieldValue);
        }
        if (OObjectSerializerHelper.serializerContexts.get(null) != null) {
            return OObjectSerializerHelper.serializerContexts.get(null).unserializeFieldValue(type, iFieldValue);
        }
        return iFieldValue;
    }

    public static Object typeToStream(Object iFieldValue, OType iType, ODatabaseObject db, ODocument iRecord) {
        if (iFieldValue == null) {
            return null;
        }
        if (iFieldValue instanceof Proxy) {
            return OObjectEntitySerializer.getDocument((Proxy)iFieldValue);
        }
        if (!OType.isSimpleType(iFieldValue) || iFieldValue.getClass().isArray()) {
            Class<?> fieldClass = iFieldValue.getClass();
            if (fieldClass.isArray()) {
                int arrayLength = Array.getLength(iFieldValue);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int i = 0;
                while (i < arrayLength) {
                    arrayList.add(Array.get(iFieldValue, i));
                    ++i;
                }
                iFieldValue = OObjectEntitySerializer.multiValueToStream(arrayList, iType, db, iRecord);
            } else if (Collection.class.isAssignableFrom(fieldClass)) {
                iFieldValue = OObjectEntitySerializer.multiValueToStream(iFieldValue, iType, db, iRecord);
            } else if (Map.class.isAssignableFrom(fieldClass)) {
                iFieldValue = OObjectEntitySerializer.multiValueToStream(iFieldValue, iType, db, iRecord);
            } else if (fieldClass.isEnum()) {
                iFieldValue = ((Enum)iFieldValue).name();
            } else {
                fieldClass = db.getEntityManager().getEntityClass(fieldClass.getSimpleName());
                if (fieldClass != null) {
                    iFieldValue = OObjectEntitySerializer.getDocument((Proxy)OObjectEntitySerializer.serializeObject(iFieldValue, db));
                } else {
                    Object result = OObjectEntitySerializer.serializeFieldValue(null, iFieldValue);
                    if (iFieldValue == result) {
                        throw new OSerializationException("Linked type [" + iFieldValue.getClass() + ":" + iFieldValue + "] cannot be serialized because is not part of registered entities. To fix this error register this class");
                    }
                    iFieldValue = result;
                }
            }
        }
        return iFieldValue;
    }

    public static boolean hasBoundedDocumentField(Class<?> iClass) {
        if (!classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        boolean hasBoundedField = false;
        Class<?> currentClass = iClass;
        while (currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && !hasBoundedField) {
            hasBoundedField = boundDocumentFields.get(currentClass) != null;
            currentClass = currentClass.getSuperclass();
        }
        return hasBoundedField;
    }

    public static Field getBoundedDocumentField(Class<?> iClass) {
        if (!classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        Class<?> currentClass = iClass;
        while (currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class)) {
            Field f = boundDocumentFields.get(currentClass);
            if (f != null) {
                return f;
            }
            currentClass = currentClass.getSuperclass();
        }
        return null;
    }

    public static boolean isIdField(Class<?> iClass, String iFieldName) {
        if (!classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        boolean isIdField = false;
        Class<?> currentClass = iClass;
        while (currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && !isIdField) {
            Field f = fieldIds.get(currentClass);
            isIdField = f != null && f.getName().equals(iFieldName);
            currentClass = currentClass.getSuperclass();
        }
        return isIdField;
    }

    public static boolean isIdField(Field iField) {
        if (!classes.contains(iField.getDeclaringClass())) {
            OObjectEntitySerializer.registerClass(iField.getDeclaringClass());
        }
        return fieldIds.containsValue(iField);
    }

    public static void setIdField(Class<?> iClass, Object iObject, ORID iValue) throws IllegalArgumentException, IllegalAccessException {
        if (!classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        Field f = null;
        Class<?> currentClass = iClass;
        while (currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class)) {
            f = fieldIds.get(currentClass);
            if (f != null) break;
            currentClass = currentClass.getSuperclass();
        }
        if (f != null) {
            if (f.getType().equals(String.class)) {
                OObjectEntitySerializer.setFieldValue(f, iObject, iValue.toString());
            } else if (f.getType().equals(Long.class)) {
                OObjectEntitySerializer.setFieldValue(f, iObject, iValue.getClusterPosition());
            } else if (f.getType().equals(Object.class)) {
                OObjectEntitySerializer.setFieldValue(f, iObject, iValue);
            }
        }
    }

    public static boolean isVersionField(Class<?> iClass, String iFieldName) {
        if (!classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        boolean isVersionField = false;
        Class<?> currentClass = iClass;
        while (currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && !isVersionField) {
            Field f = fieldVersions.get(currentClass);
            isVersionField = f != null && f.getName().equals(iFieldName);
            currentClass = currentClass.getSuperclass();
        }
        return isVersionField;
    }

    public static void setVersionField(Class<?> iClass, Object iObject, int iValue) throws IllegalArgumentException, IllegalAccessException {
        if (!classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        Field f = null;
        Class<?> currentClass = iClass;
        while (currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class)) {
            f = fieldVersions.get(currentClass);
            if (f != null) break;
            currentClass = currentClass.getSuperclass();
        }
        if (f != null) {
            OObjectEntitySerializer.setFieldValue(f, iObject, iValue);
        }
    }

    public static Object getFieldValue(Field iField, Object iInstance) throws IllegalArgumentException, IllegalAccessException {
        if (!iField.isAccessible()) {
            iField.setAccessible(true);
        }
        return iField.get(iInstance);
    }

    public static void setFieldValue(Field iField, Object iInstance, Object iValue) throws IllegalArgumentException, IllegalAccessException {
        if (!iField.isAccessible()) {
            iField.setAccessible(true);
        }
        iField.set(iInstance, iValue);
    }

    public static void invokeBeforeSerializationCallbacks(Class<?> iClass, Object iInstance, ODocument iDocument) {
        OObjectEntitySerializer.invokeCallback(iClass, iInstance, iDocument, OBeforeSerialization.class);
    }

    public static void invokeAfterSerializationCallbacks(Class<?> iClass, Object iInstance, ODocument iDocument) {
        OObjectEntitySerializer.invokeCallback(iClass, iInstance, iDocument, OAfterSerialization.class);
    }

    public static void invokeAfterDeserializationCallbacks(Class<?> iClass, Object iInstance, ODocument iDocument) {
        OObjectEntitySerializer.invokeCallback(iClass, iInstance, iDocument, OAfterDeserialization.class);
    }

    public static void invokeBeforeDeserializationCallbacks(Class<?> iClass, Object iInstance, ODocument iDocument) {
        OObjectEntitySerializer.invokeCallback(iClass, iInstance, iDocument, OBeforeDeserialization.class);
    }

    protected static <T> T toStream(T iPojo, Proxy iProxiedPojo, ODatabaseObject db) throws IllegalArgumentException, IllegalAccessException {
        Object id;
        ODocument iRecord = OObjectEntitySerializer.getDocument(iProxiedPojo);
        long timer = OProfiler.getInstance().startChrono();
        Integer identityRecord = System.identityHashCode(iPojo);
        if (((Map)OObjectSerializationThreadLocal.INSTANCE.get()).containsKey(identityRecord)) {
            return (T)((Map)OObjectSerializationThreadLocal.INSTANCE.get()).get(identityRecord);
        }
        ((Map)OObjectSerializationThreadLocal.INSTANCE.get()).put(identityRecord, iProxiedPojo);
        Class<?> pojoClass = iPojo.getClass();
        OClass schemaClass = iRecord.getSchemaClass();
        Field idField = OObjectEntitySerializer.getIdField(pojoClass);
        if (idField != null && (id = OObjectEntitySerializer.getFieldValue(idField, iPojo)) != null) {
            if (id instanceof ORecordId) {
                iRecord.setIdentity((ORecordId)id);
            } else if (id instanceof Number) {
                ((ORecordId)iRecord.getIdentity()).clusterId = schemaClass.getDefaultClusterId();
                ((ORecordId)iRecord.getIdentity()).clusterPosition = ((Number)id).longValue();
            } else if (id instanceof String) {
                ((ORecordId)iRecord.getIdentity()).fromString((String)id);
            } else if (id.getClass().equals(Object.class)) {
                iRecord.setIdentity((ORecordId)id);
            } else {
                OLogManager.instance().warn(OObjectSerializerHelper.class, "@Id field has been declared as %s while the supported are: ORID, Number, String, Object", new Object[]{id.getClass()});
            }
        }
        Field vField = OObjectEntitySerializer.getVersionField(pojoClass);
        boolean versionConfigured = false;
        if (vField != null) {
            versionConfigured = true;
            Object ver = OObjectEntitySerializer.getFieldValue(vField, iPojo);
            if (ver != null) {
                if (ver instanceof Number) {
                    iRecord.setVersion(((Number)ver).intValue());
                } else if (ver instanceof String) {
                    iRecord.setVersion(Integer.parseInt((String)ver));
                } else if (ver.getClass().equals(Object.class)) {
                    iRecord.setVersion((Integer)ver);
                } else {
                    OLogManager.instance().warn(OObjectSerializerHelper.class, "@Version field has been declared as %s while the supported are: Number, String, Object", new Object[]{ver.getClass()});
                }
            }
        }
        if (db.isMVCC() && !versionConfigured && db.getTransaction() instanceof OTransactionOptimistic) {
            throw new OTransactionException("Cannot involve an object of class '" + pojoClass + "' in an Optimistic Transaction commit because it does not define @Version or @OVersion and therefore cannot handle MVCC");
        }
        OObjectEntitySerializer.invokeCallback(pojoClass, iProxiedPojo, iRecord, OBeforeSerialization.class);
        Class<Object> currentClass = pojoClass;
        while (!currentClass.equals(Object.class) && classes.contains(pojoClass)) {
            Field[] fieldArray = currentClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field p = fieldArray[n2];
                if (!(Modifier.isStatic(p.getModifiers()) || Modifier.isNative(p.getModifiers()) || Modifier.isTransient(p.getModifiers()))) {
                    String fieldName = p.getName();
                    List<String> classTransientFields = transientFields.get(pojoClass);
                    if (!(idField != null && fieldName.equals(idField.getName()) || vField != null && fieldName.equals(vField.getName()) || classTransientFields != null && classTransientFields.contains(fieldName))) {
                        OProperty schemaProperty;
                        Object fieldValue = OObjectEntitySerializer.getFieldValue(p, iPojo);
                        if (OObjectEntitySerializer.isSerializedType(p)) {
                            fieldValue = OObjectEntitySerializer.serializeFieldValue(p.getType(), fieldValue);
                        }
                        OProperty oProperty = schemaProperty = schemaClass != null ? schemaClass.getProperty(fieldName) : null;
                        if (fieldValue != null && OObjectEntitySerializer.isEmbeddedObject(p)) {
                            if (iRecord.getSchemaClass() == null) {
                                db.getMetadata().getSchema().createClass(iPojo.getClass());
                                iRecord.setClassNameIfExists(iPojo.getClass().getSimpleName());
                            }
                            if (schemaProperty == null) {
                                OType t = OType.getTypeByClass(fieldValue.getClass());
                                if (t == null) {
                                    t = OType.EMBEDDED;
                                }
                                schemaProperty = iRecord.getSchemaClass().createProperty(fieldName, t);
                            }
                        }
                        fieldValue = OObjectEntitySerializer.typeToStream(fieldValue, schemaProperty != null ? schemaProperty.getType() : null, db, iRecord);
                        iRecord.field(fieldName, fieldValue);
                    }
                }
                ++n2;
            }
            if ((currentClass = currentClass.getSuperclass()) != null && !currentClass.equals(ODocument.class)) continue;
            currentClass = Object.class;
        }
        OObjectEntitySerializer.invokeCallback(pojoClass, iProxiedPojo, iRecord, OAfterSerialization.class);
        ((Map)OObjectSerializationThreadLocal.INSTANCE.get()).remove(identityRecord);
        OProfiler.getInstance().stopChrono("Object.toStream", timer);
        return (T)iProxiedPojo;
    }

    protected static Field getIdField(Class<?> iClass) {
        if (!classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        return fieldIds.get(iClass);
    }

    protected static Field getVersionField(Class<?> iClass) {
        if (!classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        return fieldVersions.get(iClass);
    }

    protected static void invokeCallback(Object iPojo, ODocument iDocument, Class<?> iAnnotation) {
        OObjectEntitySerializer.invokeCallback(iPojo.getClass(), iPojo, iDocument, iAnnotation);
    }

    protected static void invokeCallback(Class<?> iClass, Object iPojo, ODocument iDocument, Class<?> iAnnotation) {
        Method m = OObjectEntitySerializer.getCallbackMethod(iAnnotation, iClass);
        if (m != null) {
            try {
                if (m.getParameterTypes().length > 0) {
                    m.invoke(iPojo, iDocument);
                } else {
                    m.invoke(iPojo, new Object[0]);
                }
            }
            catch (Exception e) {
                throw new OConfigurationException("Error on executing user callback '" + m.getName() + "' annotated with '" + iAnnotation.getSimpleName() + "'", e);
            }
        }
    }

    protected static Method getCallbackMethod(Class<?> iAnnotation, Class<?> iClass) {
        if (!classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        return callbacks.get(String.valueOf(iClass.getSimpleName()) + "." + iAnnotation.getSimpleName());
    }

    private static void registerCallbacks(Class<?> iRootClass) {
        Method[] methodArray = iRootClass.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Class<?>[] classArray = OObjectSerializerHelper.callbackAnnotationClasses;
            int n3 = OObjectSerializerHelper.callbackAnnotationClasses.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> annotationClass = classArray[n4];
                if (m.getAnnotation(annotationClass) != null) {
                    callbacks.put(String.valueOf(iRootClass.getSimpleName()) + "." + annotationClass.getSimpleName(), m);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static Object multiValueToStream(Object iMultiValue, OType iType, ODatabaseObject db, ODocument iRecord) {
        OType linkedType;
        if (iMultiValue == null) {
            return null;
        }
        Collection sourceValues = iMultiValue instanceof Collection ? (Collection)iMultiValue : ((Map)((Object)iMultiValue)).values();
        if (sourceValues.size() == 0) {
            return iMultiValue;
        }
        Object firstValue = sourceValues.iterator().next();
        if (firstValue == null) {
            return iMultiValue;
        }
        if (iType == null) {
            iType = OType.isSimpleType(firstValue) ? (iMultiValue instanceof List ? OType.EMBEDDEDLIST : (iMultiValue instanceof Set ? OType.EMBEDDEDSET : OType.EMBEDDEDMAP)) : (iMultiValue instanceof List ? OType.LINKLIST : (iMultiValue instanceof Set ? OType.LINKSET : OType.LINKMAP));
        }
        Set<Object> result = iMultiValue;
        if (iType.equals((Object)OType.EMBEDDEDSET) || iType.equals((Object)OType.LINKSET)) {
            result = OObjectEntitySerializer.isToSerialize(firstValue.getClass()) ? new HashSet() : (iRecord != null && iType.equals((Object)OType.EMBEDDEDSET) ? new OTrackedSet(iRecord) : new ORecordLazySet(iRecord));
        } else if (iType.equals((Object)OType.EMBEDDEDLIST) || iType.equals((Object)OType.LINKLIST)) {
            result = OObjectEntitySerializer.isToSerialize(firstValue.getClass()) ? new ArrayList() : (iRecord != null && iType.equals((Object)OType.EMBEDDEDLIST) ? new OTrackedList(iRecord) : new ORecordLazyList(iRecord));
        }
        if (iType.equals((Object)OType.LINKLIST) || iType.equals((Object)OType.LINKSET) || iType.equals((Object)OType.LINKMAP)) {
            linkedType = OType.LINK;
        } else if (iType.equals((Object)OType.EMBEDDEDLIST) || iType.equals((Object)OType.EMBEDDEDSET) || iType.equals((Object)OType.EMBEDDEDMAP)) {
            linkedType = OType.EMBEDDED;
        } else {
            throw new IllegalArgumentException("Type " + (Object)((Object)iType) + " must be a multi value type (collection or map)");
        }
        if (iMultiValue instanceof Set) {
            for (Object o : sourceValues) {
                ((Set)result).add(OObjectEntitySerializer.typeToStream(o, linkedType, db, null));
            }
        } else if (iMultiValue instanceof List) {
            int i = 0;
            while (i < sourceValues.size()) {
                ((List)((Object)result)).add(OObjectEntitySerializer.typeToStream(((List)sourceValues).get(i), linkedType, db, null));
                ++i;
            }
        } else if (iMultiValue instanceof OObjectLazyMap) {
            result = ((OObjectLazyMap)((Object)iMultiValue)).getUnderlying();
        } else {
            result = OObjectEntitySerializer.isToSerialize(firstValue.getClass()) ? new HashMap() : (iRecord != null && iType.equals((Object)OType.EMBEDDEDMAP) ? new OTrackedMap(iRecord) : new ORecordLazyMap(iRecord));
            for (Map.Entry entry : ((Map)((Object)iMultiValue)).entrySet()) {
                ((Map)((Object)result)).put(entry.getKey(), OObjectEntitySerializer.typeToStream(entry.getValue(), linkedType, db, null));
            }
        }
        return result;
    }

    private static boolean isEmbeddedObject(Field f) {
        if (!classes.contains(f.getDeclaringClass())) {
            OObjectEntitySerializer.registerClass(f.getDeclaringClass());
        }
        return OObjectEntitySerializer.isEmbeddedField(f.getDeclaringClass(), f.getName());
    }
}

