/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.fetch;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.exception.OFetchException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.OLazyObjectList;
import com.orientechnologies.orient.object.db.OLazyObjectMap;
import com.orientechnologies.orient.object.db.OLazyObjectSet;
import com.orientechnologies.orient.object.fetch.OObjectFetchContext;
import com.orientechnologies.orient.object.serialization.OObjectSerializerHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectFetchListener
implements OFetchListener {
    @Override
    public void processStandardField(ORecordSchemaAware<?> iRecord, Object iFieldValue, String iFieldName, OFetchContext iContext, Object iUserObject) throws OFetchException {
        if (iFieldValue instanceof ORecordLazyList) {
            OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, new OLazyObjectList(iRecord, (ORecordLazyList)iFieldValue));
        } else if (iFieldValue instanceof ORecordLazySet) {
            OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, new OLazyObjectSet(iRecord, (ORecordLazyList)iFieldValue));
        } else if (iFieldValue instanceof ORecordLazyMap) {
            OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, new OLazyObjectMap(iRecord, (ORecordLazyMap)iFieldValue));
        } else {
            OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, iFieldValue);
        }
    }

    public void processStandardCollectionValue(Object iFieldValue, OFetchContext iContext) throws OFetchException {
    }

    @Override
    public void parseLinkedCollectionValue(ORecordSchemaAware<?> iRootRecord, OIdentifiable iLinked, Object iUserObject, String iFieldName, OFetchContext iContext) throws OFetchException {
    }

    @Override
    public void parseLinked(ORecordSchemaAware<?> iRootRecord, OIdentifiable iLinked, Object iUserObject, String iFieldName, OFetchContext iContext) throws OFetchException {
        Class<?> type = OObjectSerializerHelper.getFieldType(iUserObject, iFieldName);
        if (type != null && !Map.class.isAssignableFrom(type)) {
            if (Set.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || type.isArray()) {
                if (!((OObjectFetchContext)iContext).isLazyLoading()) {
                    Object value = ((OObjectFetchContext)iContext).getObj2RecHandler().getUserObjectByRecord((ODocument)iLinked, ((OObjectFetchContext)iContext).getFetchPlan());
                    if (!((OObjectFetchContext)iContext).isLazyLoading()) {
                        Collection target = (Collection)OObjectSerializerHelper.getFieldValue(iUserObject, iFieldName);
                        target.add(value);
                        OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, target);
                    }
                }
                return;
            }
            if (iLinked instanceof ORecordSchemaAware && !((OObjectFetchContext)iContext).getObj2RecHandler().existsUserObjectByRID(iLinked.getIdentity())) {
                this.fetchLinked(iRootRecord, iUserObject, iFieldName, (ORecordSchemaAware)iLinked, iContext);
            }
        }
    }

    @Override
    public Object fetchLinkedMapEntry(ORecordSchemaAware<?> iRoot, Object iUserObject, String iFieldName, String iKey, ORecordSchemaAware<?> iLinked, OFetchContext iContext) throws OFetchException {
        Object value = null;
        Class<?> type = OObjectSerializerHelper.getFieldType((ODocument)iLinked, ((OObjectFetchContext)iContext).getEntityManager());
        Class<?> fieldClass = ((OObjectFetchContext)iContext).getEntityManager().getEntityClass(type.getSimpleName());
        if (fieldClass != null) {
            value = ((OObjectFetchContext)iContext).getObj2RecHandler().getUserObjectByRecord((ODocument)iLinked, ((OObjectFetchContext)iContext).getFetchPlan());
        }
        return value;
    }

    @Override
    public Object fetchLinkedCollectionValue(ORecordSchemaAware<?> iRoot, Object iUserObject, String iFieldName, ORecordSchemaAware<?> iLinked, OFetchContext iContext) throws OFetchException {
        Object value = null;
        Class<?> fieldClass = OObjectSerializerHelper.getFieldType((ODocument)iLinked, ((OObjectFetchContext)iContext).getEntityManager());
        if (fieldClass != null) {
            value = ((OObjectFetchContext)iContext).getObj2RecHandler().getUserObjectByRecord((ODocument)iLinked, ((OObjectFetchContext)iContext).getFetchPlan());
            if (!((OObjectFetchContext)iContext).isLazyLoading()) {
                Collection target = (Collection)OObjectSerializerHelper.getFieldValue(iUserObject, iFieldName);
                target.add(value);
                OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, target);
            }
        }
        return value;
    }

    @Override
    public Object fetchLinked(ORecordSchemaAware<?> iRoot, Object iUserObject, String iFieldName, ORecordSchemaAware<?> iLinked, OFetchContext iContext) throws OFetchException {
        if (iUserObject == null) {
            return null;
        }
        Class<?> type = iLinked != null && iLinked instanceof ODocument ? OObjectSerializerHelper.getFieldType((ODocument)iLinked, ((OObjectFetchContext)iContext).getEntityManager()) : OObjectSerializerHelper.getFieldType(iUserObject, iFieldName);
        if (type == null) {
            throw new OSerializationException("Linked type of field '" + iRoot.getClassName() + "." + iFieldName + "' is unknown. Probably needs to be registered with <db>.getEntityManager().registerEntityClasses(<package>) or <db>.getEntityManager().registerEntityClass(<class>) or the package cannot be loaded correctly due to a classpath problem. In this case register the single classes one by one.");
        }
        Object fieldValue = null;
        if (type.isEnum()) {
            String enumName = (String)((ODocument)iLinked).field(iFieldName);
            Class<?> enumClass = type;
            fieldValue = Enum.valueOf(enumClass, enumName);
        } else {
            Class<?> fieldClass = ((OObjectFetchContext)iContext).getEntityManager().getEntityClass(type.getSimpleName());
            if (fieldClass != null && !((OObjectFetchContext)iContext).isLazyLoading()) {
                fieldValue = ((OObjectFetchContext)iContext).getObj2RecHandler().getUserObjectByRecord((ODocument)iLinked, ((OObjectFetchContext)iContext).getFetchPlan());
                OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, OObjectSerializerHelper.unserializeFieldValue(OObjectSerializerHelper.getFieldType(iUserObject, iFieldName), fieldValue));
            }
        }
        return fieldValue;
    }
}

