/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.iterator;

import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.iterator.object.OObjectIteratorClusterInterface;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectIteratorCluster<T>
implements OObjectIteratorClusterInterface<T> {
    private ODatabaseObject database;
    private ORecordIteratorCluster<ODocument> underlying;
    private String fetchPlan;

    public OObjectIteratorCluster(ODatabaseObject iDatabase, ODatabaseRecordAbstract iUnderlyingDatabase, int iClusterId) {
        this.database = iDatabase;
        this.underlying = new ORecordIteratorCluster((ODatabaseRecord)iDatabase.getUnderlying(), iUnderlyingDatabase, iClusterId);
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public T next() {
        return this.next(this.fetchPlan);
    }

    public T next(String iFetchPlan) {
        return (T)this.database.getUserObjectByRecord((ORecordInternal<?>)this.underlying.next(), iFetchPlan);
    }

    @Override
    public void remove() {
        this.underlying.remove();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public OObjectIteratorCluster<T> setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return this;
    }
}

