/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.util.structures.ArrayQueue;
import com.tinkerpop.pipes.util.structures.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;

public class OrderPipe<S>
extends AbstractPipe<S, S> {
    private final ArrayQueue<ObjectBundle<S>> bundles = new ArrayQueue();
    private final ArrayQueue<S> objects = new ArrayQueue();
    private Comparator<ObjectBundle<S>> bundledComparator;
    private Comparator<S> objectComparator;
    private List currentPath;

    public OrderPipe(PipeFunction<Pair<S, S>, Integer> compareFunction) {
        this.objectComparator = new PipeFunctionComparator(compareFunction);
        this.bundledComparator = new PipeFunctionBundleComparator(compareFunction);
    }

    public OrderPipe() {
        this.objectComparator = null;
        this.bundledComparator = null;
    }

    @Override
    public void enablePath(boolean enablePath) {
        if (enablePath) {
            this.objectComparator = null;
        } else {
            this.bundledComparator = null;
        }
        super.enablePath(enablePath);
    }

    @Override
    public S processNextStart() {
        while (true) {
            if (this.pathEnabled) {
                if (this.bundles.isEmpty()) {
                    if (!this.starts.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.bundles.clear();
                    try {
                        while (true) {
                            this.bundles.add(new ObjectBundle(this.starts.next(), this.getPathToHere()));
                        }
                    }
                    catch (NoSuchElementException e) {
                        if (null != this.objectComparator) {
                            Collections.sort(this.bundles, this.bundledComparator);
                        }
                        Collections.sort(this.bundles);
                    }
                    continue;
                }
                ObjectBundle<S> object = this.bundles.remove();
                this.currentPath = object.path;
                return object.object;
            }
            if (!this.objects.isEmpty()) break;
            if (!this.starts.hasNext()) {
                throw new NoSuchElementException();
            }
            this.objects.clear();
            try {
                while (true) {
                    this.objects.add(this.starts.next());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (null != this.objectComparator) {
                    Collections.sort(this.objects, this.objectComparator);
                    continue;
                }
                Collections.sort(this.objects);
                continue;
            }
            break;
        }
        return this.objects.remove();
    }

    @Override
    public List getCurrentPath() {
        if (this.pathEnabled) {
            ArrayList<Object> pathElements = new ArrayList<Object>(this.currentPath);
            int size = pathElements.size();
            if (size == 0 || pathElements.get(size - 1) != this.currentEnd) {
                pathElements.add(this.currentEnd);
            }
            return pathElements;
        }
        throw new RuntimeException("Path calculations are not enabled");
    }

    private class PipeFunctionComparator
    implements Comparator<S> {
        private final PipeFunction<Pair<S, S>, Integer> pipeFunction;

        public PipeFunctionComparator(PipeFunction<Pair<S, S>, Integer> pipeFunction) {
            this.pipeFunction = pipeFunction;
        }

        @Override
        public int compare(S a, S b) {
            return this.pipeFunction.compute(new Pair(a, b));
        }
    }

    private class PipeFunctionBundleComparator
    implements Comparator<ObjectBundle<S>> {
        private final PipeFunction<Pair<S, S>, Integer> pipeFunction;

        public PipeFunctionBundleComparator(PipeFunction<Pair<S, S>, Integer> pipeFunction) {
            this.pipeFunction = pipeFunction;
        }

        @Override
        public int compare(ObjectBundle<S> a, ObjectBundle<S> b) {
            return this.pipeFunction.compute(new Pair(a.object, b.object));
        }
    }

    private class ObjectBundle<S>
    implements Comparable<ObjectBundle<S>> {
        public final S object;
        public final List path;

        public ObjectBundle(S object, List path) {
            this.object = object;
            this.path = path;
        }

        @Override
        public int compareTo(ObjectBundle bundle) {
            return ((Comparable)this.object).compareTo(bundle.object);
        }
    }
}

