/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class PathFunctionPipe<S>
extends AbstractPipe<S, List> {
    private final PipeFunction[] pathFunctions;

    public PathFunctionPipe(PipeFunction ... pathFunctions) {
        this.pathFunctions = pathFunctions;
    }

    @Override
    public void setStarts(Iterator<S> starts) {
        this.starts = starts;
    }

    @Override
    public List processNextStart() {
        if (this.starts instanceof Pipe) {
            this.starts.next();
            List path = ((Pipe)this.starts).getPath();
            LinkedList closedPath = new LinkedList();
            int nextFunction = 0;
            for (Object object : path) {
                closedPath.add(this.pathFunctions[nextFunction].compute(object));
                nextFunction = (nextFunction + 1) % this.pathFunctions.length;
            }
            return closedPath;
        }
        throw new NoSuchElementException("The start of this pipe was not a pipe");
    }
}

