/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.util;

import com.tinkerpop.pipes.PipeFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Table
extends ArrayList<Row> {
    private List<String> columnNames;
    private int tableWidth = -1;

    public Table() {
        this.columnNames = new ArrayList<String>();
    }

    public Table(String ... columnNames) {
        this.columnNames = Arrays.asList(columnNames);
        this.tableWidth = columnNames.length;
    }

    public Table apply(PipeFunction ... functions) {
        if (this.tableWidth != -1 && functions.length == this.tableWidth) {
            Table table = new Table();
            for (Row row : this) {
                ArrayList temp = new ArrayList();
                int i = 0;
                while (i < row.size()) {
                    temp.add(functions[i].compute(row.get(i)));
                    ++i;
                }
                table.addRow(temp);
            }
            return table;
        }
        throw new RuntimeException("Table width is " + this.tableWidth + " and functions length is " + functions.length);
    }

    public void addRow(List row) {
        if (this.tableWidth == -1) {
            this.tableWidth = row.size();
        } else if (row.size() != this.tableWidth) {
            throw new RuntimeException("Table width is " + this.tableWidth + " and row width is " + row.size());
        }
        this.add(new Row(row));
    }

    public void addRow(Object ... row) {
        this.addRow(Arrays.asList(row));
    }

    public void setColumnNames(String ... columnNames) {
        if (this.tableWidth != -1 && columnNames.length != this.tableWidth) {
            throw new RuntimeException("Table width is " + this.tableWidth + " and there are " + columnNames.length + " column names");
        }
        this.columnNames = Arrays.asList(columnNames);
        this.tableWidth = this.columnNames.size();
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public int getRowCount() {
        return this.size();
    }

    public int getColumnCount() {
        return this.tableWidth;
    }

    public Object get(int row, int column) {
        return ((Row)this.get(row)).get(column);
    }

    public Object get(int row, String columnName) {
        return ((Row)this.get(row)).get(this.columnNames.indexOf(columnName));
    }

    public Row getRow(int row) {
        return (Row)this.get(row);
    }

    public List getColumn(int column) {
        ArrayList temp = new ArrayList();
        for (Row row : this) {
            temp.add(row.get(column));
        }
        return temp;
    }

    public List getColumn(String columnName) {
        return this.getColumn(this.columnNames.indexOf(columnName));
    }

    @Override
    public void clear() {
        super.clear();
        this.tableWidth = -1;
        this.columnNames = new ArrayList<String>();
    }

    public class Row
    extends ArrayList {
        public Row(List row) {
            super(row);
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer("[");
            int i = 0;
            while (i < this.size()) {
                if (Table.this.columnNames.size() > 0) {
                    buffer.append((String)Table.this.columnNames.get(i));
                    buffer.append(":");
                }
                buffer.append(this.get(i));
                if (i < this.size() - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
            buffer.append("]");
            return buffer.toString();
        }

        public Object getColumn(String columnName) {
            return this.get(Table.this.columnNames.indexOf(columnName));
        }

        public Object getColumn(int column) {
            return this.get(column);
        }
    }
}

