/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.sail;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.sail.SailGraph;
import com.tinkerpop.blueprints.pgm.impls.sail.SailHelper;
import com.tinkerpop.blueprints.pgm.impls.sail.SailVertex;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;

public class SailEdge
implements Edge {
    protected Statement rawEdge;
    protected SailGraph graph;
    private static final String NAMED_GRAPH_PROPERTY = "RDF graph edges can only have partition graph (ng) properties";

    public SailEdge(Statement rawEdge, SailGraph graph) {
        this.rawEdge = rawEdge;
        this.graph = graph;
    }

    public Statement getRawEdge() {
        return this.rawEdge;
    }

    public String getLabel() {
        return this.rawEdge.getPredicate().stringValue();
    }

    public String getNamedGraph() {
        return (String)this.getProperty("ng");
    }

    public void setNamedGraph(String namedGraph) {
        this.setProperty("ng", namedGraph);
    }

    public boolean hasNamedGraph() {
        return this.getProperty("ng") != null;
    }

    public Set<String> getPropertyKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (null != this.rawEdge.getContext()) {
            keys.add("ng");
        }
        return keys;
    }

    public Object getProperty(String key) {
        if (key.equals("ng")) {
            Resource resource = this.rawEdge.getContext();
            if (null == resource) {
                return null;
            }
            return resource.stringValue();
        }
        return null;
    }

    public void setProperty(String key, Object value) {
        if (key.equals("ng")) {
            try {
                URIImpl namedGraph = new URIImpl(this.graph.expandPrefix(value.toString()));
                SailHelper.removeStatement(this.rawEdge, this.graph.getSailConnection().get());
                this.rawEdge = new ContextStatementImpl(this.rawEdge.getSubject(), this.rawEdge.getPredicate(), this.rawEdge.getObject(), (Resource)namedGraph);
                SailHelper.addStatement(this.rawEdge, this.graph.getSailConnection().get());
                this.graph.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            }
            catch (Exception e) {
                this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
                throw new RuntimeException(e.getMessage(), e);
            }
        } else {
            throw new RuntimeException(NAMED_GRAPH_PROPERTY);
        }
    }

    public Object removeProperty(String key) {
        if (key.equals("ng")) {
            try {
                Resource ng = this.rawEdge.getContext();
                SailHelper.removeStatement(this.rawEdge, this.graph.getSailConnection().get());
                this.rawEdge = new StatementImpl(this.rawEdge.getSubject(), this.rawEdge.getPredicate(), this.rawEdge.getObject());
                SailHelper.addStatement(this.rawEdge, this.graph.getSailConnection().get());
                this.graph.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
                return ng;
            }
            catch (Exception e) {
                this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new RuntimeException(NAMED_GRAPH_PROPERTY);
    }

    public Vertex getInVertex() {
        return new SailVertex(this.rawEdge.getObject(), this.graph);
    }

    public Vertex getOutVertex() {
        return new SailVertex((Value)this.rawEdge.getSubject(), this.graph);
    }

    public String toString() {
        String outVertex = this.graph.prefixNamespace(this.rawEdge.getSubject().stringValue());
        String edgeLabel = this.graph.prefixNamespace(this.rawEdge.getPredicate().stringValue());
        String inVertex = this.rawEdge.getObject() instanceof Resource ? this.graph.prefixNamespace(this.rawEdge.getObject().stringValue()) : this.literalString((Literal)this.rawEdge.getObject());
        String namedGraph = null;
        if (null != this.rawEdge.getContext()) {
            namedGraph = this.graph.prefixNamespace(this.rawEdge.getContext().stringValue());
        }
        String edgeString = "e[" + outVertex + " - " + edgeLabel + " -> " + inVertex + "]";
        if (null != namedGraph) {
            edgeString = edgeString + "<" + namedGraph + ">";
        }
        return edgeString;
    }

    private String literalString(Literal literal) {
        String language = literal.getLanguage();
        URI datatype = literal.getDatatype();
        if (null != datatype) {
            return "\"" + literal.getLabel() + "\"^^<" + this.graph.prefixNamespace(datatype.stringValue()) + ">";
        }
        if (null != language) {
            return "\"" + literal.getLabel() + "\"@" + language;
        }
        return "\"" + literal.getLabel() + "\"";
    }

    public boolean equals(Object object) {
        return object instanceof SailEdge && ((SailEdge)object).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Object getId() {
        if (null != this.rawEdge.getContext()) {
            return "(" + this.rawEdge.getSubject() + ", " + this.rawEdge.getPredicate() + ", " + this.rawEdge.getObject() + ") [" + this.rawEdge.getContext() + "]";
        }
        return "(" + this.rawEdge.getSubject() + ", " + this.rawEdge.getPredicate() + ", " + this.rawEdge.getObject() + ")";
    }
}

