/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.sail;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.MetaGraph;
import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.sail.SailEdge;
import com.tinkerpop.blueprints.pgm.impls.sail.SailHelper;
import com.tinkerpop.blueprints.pgm.impls.sail.SailVertex;
import com.tinkerpop.blueprints.pgm.impls.sail.util.SailEdgeSequence;
import info.aduna.iteration.CloseableIteration;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fortytwo.sesametools.nquads.NQuadsFormat;
import org.apache.log4j.PropertyConfigurator;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.sparql.SPARQLParser;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class SailGraph
implements TransactionalGraph,
MetaGraph<Sail> {
    public static final Map<String, RDFFormat> formats = new HashMap<String, RDFFormat>();
    private final List<SailConnection> connections = new LinkedList<SailConnection>();
    protected final Sail rawGraph;
    protected final ThreadLocal<SailConnection> sailConnection = new ThreadLocal<SailConnection>(){

        @Override
        protected SailConnection initialValue() {
            SailConnection sc = null;
            try {
                sc = SailGraph.this.createConnection();
            }
            catch (SailException e) {
                e.printStackTrace(System.err);
            }
            return sc;
        }
    };
    private final ThreadLocal<Boolean> inTransaction = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final ThreadLocal<Integer> txBuffer = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    private final ThreadLocal<Integer> txCounter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static final String LOG4J_PROPERTIES = "log4j.properties";

    public static RDFFormat getFormat(String format) {
        RDFFormat ret = formats.get(format);
        if (null == ret) {
            throw new RuntimeException(format + " is an unsupported RDF file format. Use rdf-xml, n-triples, n-quads, turtle, n3, trix, or trig");
        }
        return ret;
    }

    public SailGraph(Sail sail) {
        try {
            PropertyConfigurator.configure((URL)SailGraph.class.getResource(LOG4J_PROPERTIES));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.rawGraph = sail;
            sail.initialize();
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void addDefaultNamespaces() {
        this.addNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.addNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.addNamespace("owl", "http://www.w3.org/2002/07/owl#");
        this.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.addNamespace("foaf", "http://xmlns.com/foaf/0.1/");
    }

    public Sail getRawGraph() {
        return this.rawGraph;
    }

    private Vertex createVertex(String resource) {
        if (SailHelper.isBNode(resource)) {
            return new SailVertex((Value)new BNodeImpl(resource.substring(2)), this);
        }
        Literal literal = SailHelper.makeLiteral(resource, this);
        if (literal != null) {
            return new SailVertex((Value)literal, this);
        }
        if (resource.contains(":") || resource.contains("/") || resource.contains("#")) {
            resource = this.expandPrefix(resource);
            return new SailVertex((Value)new URIImpl(resource), this);
        }
        throw new RuntimeException(resource + " is not a valid URI, blank node, or literal value");
    }

    public Vertex addVertex(Object id) {
        if (null == id) {
            id = "urn:uuid:" + UUID.randomUUID().toString();
        }
        return this.createVertex(id.toString());
    }

    public Vertex getVertex(Object id) {
        if (null == id) {
            throw new IllegalArgumentException("Element identifier cannot be null");
        }
        try {
            return this.createVertex(id.toString());
        }
        catch (RuntimeException re) {
            return null;
        }
    }

    public Edge getEdge(Object id) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Vertex> getVertices() {
        throw new UnsupportedOperationException("RDF is an edge based graph model");
    }

    public Iterable<Edge> getEdges() {
        try {
            return new SailEdgeSequence((CloseableIteration<? extends Statement, SailException>)this.sailConnection.get().getStatements(null, null, null, false, new Resource[0]), this);
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void removeVertex(Vertex vertex) {
        Value vertexValue = ((SailVertex)vertex).getRawVertex();
        try {
            if (vertexValue instanceof Resource) {
                this.sailConnection.get().removeStatements((Resource)vertexValue, null, null, new Resource[0]);
            }
            this.sailConnection.get().removeStatements(null, null, vertexValue, new Resource[0]);
            this.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (SailException e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        Value outVertexValue = ((SailVertex)outVertex).getRawVertex();
        Value inVertexValue = ((SailVertex)inVertex).getRawVertex();
        if (!(outVertexValue instanceof Resource)) {
            throw new RuntimeException(outVertex.toString() + " is not a legal URI or blank node");
        }
        try {
            URIImpl labelURI = new URIImpl(this.expandPrefix(label));
            StatementImpl statement = new StatementImpl((Resource)outVertexValue, (URI)labelURI, inVertexValue);
            SailHelper.addStatement((Statement)statement, this.sailConnection.get());
            this.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            return new SailEdge((Statement)statement, this);
        }
        catch (Exception e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void removeEdge(Edge edge) {
        Statement statement = ((SailEdge)edge).getRawEdge();
        try {
            SailHelper.removeStatement(statement, this.sailConnection.get());
            this.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (Exception e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public ThreadLocal<SailConnection> getSailConnection() {
        return this.sailConnection;
    }

    public void addNamespace(String prefix, String namespace) {
        try {
            this.sailConnection.get().setNamespace(prefix, namespace);
            this.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (SailException e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void removeNamespace(String prefix) {
        try {
            this.sailConnection.get().removeNamespace(prefix);
            this.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (SailException e) {
            this.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Map<String, String> getNamespaces() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        try {
            CloseableIteration results = this.sailConnection.get().getNamespaces();
            while (results.hasNext()) {
                Namespace namespace = (Namespace)results.next();
                namespaces.put(namespace.getPrefix(), namespace.getName());
            }
            results.close();
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return namespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRDF(InputStream input, String baseURI, String format, String baseGraph) {
        try {
            SailConnection c = this.rawGraph.getConnection();
            try {
                RDFParser p = Rio.createParser((RDFFormat)SailGraph.getFormat(format));
                SailAdder h = null == baseGraph ? new SailAdder(c, new Resource[0]) : new SailAdder(c, new Resource[]{new URIImpl(baseGraph)});
                p.setRDFHandler((RDFHandler)h);
                p.parse(input, baseURI);
                c.commit();
            }
            finally {
                c.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        try {
            this.sailConnection.get().clear(new Resource[0]);
            this.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (SailException e) {
            this.stopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private synchronized SailConnection createConnection() throws SailException {
        this.cleanupConnections();
        SailConnection sc = this.rawGraph.getConnection();
        this.connections.add(sc);
        return sc;
    }

    private void cleanupConnections() throws SailException {
        LinkedList<SailConnection> toRemove = new LinkedList<SailConnection>();
        for (SailConnection sc : this.connections) {
            if (sc.isOpen()) continue;
            toRemove.add(sc);
        }
        for (SailConnection sc : toRemove) {
            this.connections.remove(sc);
        }
    }

    private void closeAllConnections() throws SailException {
        for (SailConnection sc : this.connections) {
            if (null == sc || !sc.isOpen()) continue;
            sc.rollback();
            sc.close();
        }
    }

    public synchronized void shutdown() {
        try {
            this.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            this.closeAllConnections();
            this.rawGraph.shutDown();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String expandPrefix(String uri) {
        try {
            String namespace;
            if (uri.contains(":") && null != (namespace = this.sailConnection.get().getNamespace(uri.substring(0, uri.indexOf(":"))))) {
                uri = namespace + uri.substring(uri.indexOf(":") + 1);
            }
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return uri;
    }

    public String prefixNamespace(String uri) {
        try {
            CloseableIteration namespaces = this.sailConnection.get().getNamespaces();
            while (namespaces.hasNext()) {
                Namespace namespace = (Namespace)namespaces.next();
                if (!uri.contains(namespace.getName())) continue;
                uri = uri.replace(namespace.getName(), namespace.getPrefix() + ":");
            }
            namespaces.close();
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return uri;
    }

    public void startTransaction() {
        if (this.inTransaction.get().booleanValue()) {
            throw new RuntimeException("Stop current transaction before starting another");
        }
        this.inTransaction.set(Boolean.TRUE);
        this.txCounter.set(0);
    }

    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        try {
            if (TransactionalGraph.Conclusion.SUCCESS == conclusion) {
                this.sailConnection.get().commit();
            } else {
                this.sailConnection.get().rollback();
            }
            this.inTransaction.set(Boolean.FALSE);
            this.txCounter.set(0);
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void autoStopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (this.txBuffer.get() > 0) {
            try {
                this.txCounter.set(this.txCounter.get() + 1);
                if (conclusion == TransactionalGraph.Conclusion.FAILURE) {
                    this.sailConnection.get().rollback();
                    this.txCounter.set(0);
                    this.inTransaction.set(Boolean.FALSE);
                } else if (this.txCounter.get() % this.txBuffer.get() == 0) {
                    this.sailConnection.get().commit();
                    this.txCounter.set(0);
                    this.inTransaction.set(Boolean.FALSE);
                }
            }
            catch (SailException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public void setMaxBufferSize(int bufferSize) {
        this.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        this.inTransaction.set(Boolean.FALSE);
        this.txBuffer.set(bufferSize);
    }

    public int getMaxBufferSize() {
        return this.txBuffer.get();
    }

    public int getCurrentBufferSize() {
        return this.txCounter.get();
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.rawGraph.getClass().getSimpleName().toLowerCase());
    }

    private String getPrefixes() {
        String prefixString = "";
        Map<String, String> namespaces = this.getNamespaces();
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            prefixString = prefixString + "PREFIX " + entry.getKey() + ": <" + entry.getValue() + ">\n";
        }
        return prefixString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Vertex>> executeSparql(String sparqlQuery) throws RuntimeException {
        try {
            sparqlQuery = this.getPrefixes() + sparqlQuery;
            SPARQLParser parser = new SPARQLParser();
            ParsedQuery query = parser.parseQuery(sparqlQuery, null);
            boolean includeInferred = false;
            CloseableIteration results = this.sailConnection.get().evaluate(query.getTupleExpr(), query.getDataset(), (BindingSet)new MapBindingSet(), includeInferred);
            ArrayList<Map<String, Vertex>> returnList = new ArrayList<Map<String, Vertex>>();
            try {
                while (results.hasNext()) {
                    BindingSet bs = (BindingSet)results.next();
                    HashMap<String, Vertex> returnMap = new HashMap<String, Vertex>();
                    for (Binding b : bs) {
                        returnMap.put(b.getName(), this.getVertex(b.getValue().toString()));
                    }
                    returnList.add(returnMap);
                }
            }
            finally {
                results.close();
            }
            return returnList;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        formats.put("rdf-xml", RDFFormat.RDFXML);
        formats.put("n-triples", RDFFormat.NTRIPLES);
        formats.put("turtle", RDFFormat.TURTLE);
        formats.put("n3", RDFFormat.N3);
        formats.put("trix", RDFFormat.TRIX);
        formats.put("trig", RDFFormat.TRIG);
        formats.put("n-quads", (RDFFormat)NQuadsFormat.NQUADS);
    }

    private class SailAdder
    implements RDFHandler {
        private final SailConnection c;
        private final Resource[] contexts;

        public SailAdder(SailConnection c, Resource ... contexts) {
            this.c = c;
            this.contexts = contexts;
        }

        public void startRDF() throws RDFHandlerException {
        }

        public void endRDF() throws RDFHandlerException {
        }

        public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
            try {
                this.c.setNamespace(prefix, uri);
            }
            catch (SailException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }

        public void handleStatement(Statement s) throws RDFHandlerException {
            try {
                if (1 <= this.contexts.length) {
                    for (Resource x : this.contexts) {
                        this.c.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{x});
                    }
                } else {
                    this.c.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{s.getContext()});
                }
            }
            catch (SailException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }

        public void handleComment(String s) throws RDFHandlerException {
        }
    }
}

