/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.sail;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Query;
import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.DefaultQuery;
import com.tinkerpop.blueprints.pgm.impls.MultiIterable;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.sail.SailGraph;
import com.tinkerpop.blueprints.pgm.impls.sail.SailHelper;
import com.tinkerpop.blueprints.pgm.impls.sail.util.SailEdgeSequence;
import info.aduna.iteration.CloseableIteration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sail.SailException;

public class SailVertex
implements Vertex {
    protected Value rawVertex;
    protected SailGraph graph;
    private static final String URI_BLANK_NODE_PROPERTIES = "RDF graph URI and blank node vertices can not have properties";
    private static Map<String, String> dataTypeToClass = new HashMap<String, String>();

    public SailVertex(Value rawVertex, SailGraph graph) {
        this.rawVertex = rawVertex;
        this.graph = graph;
    }

    public Value getRawVertex() {
        return this.rawVertex;
    }

    private void updateLiteral(Literal oldLiteral, Literal newLiteral) {
        try {
            HashSet<Object> statements = new HashSet<Object>();
            CloseableIteration results = this.graph.getSailConnection().get().getStatements(null, null, (Value)oldLiteral, false, new Resource[0]);
            while (results.hasNext()) {
                statements.add(results.next());
            }
            results.close();
            this.graph.getSailConnection().get().removeStatements(null, null, (Value)oldLiteral, new Resource[0]);
            for (Statement statement : statements) {
                SailHelper.addStatement(statement.getSubject(), statement.getPredicate(), (Value)newLiteral, statement.getContext(), this.graph.getSailConnection().get());
            }
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (SailException e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void setProperty(String key, Object value) {
        if (this.rawVertex instanceof Resource) {
            throw new RuntimeException(URI_BLANK_NODE_PROPERTIES);
        }
        boolean update = false;
        Literal oldLiteral = (Literal)this.rawVertex;
        if (key.equals("type")) {
            this.rawVertex = new LiteralImpl(oldLiteral.getLabel(), (URI)new URIImpl(this.graph.expandPrefix(value.toString())));
            update = true;
        } else if (key.equals("lang")) {
            this.rawVertex = new LiteralImpl(oldLiteral.getLabel(), value.toString());
            update = true;
        }
        if (update) {
            this.updateLiteral(oldLiteral, (Literal)this.rawVertex);
        }
    }

    public Object removeProperty(String key) {
        if (this.rawVertex instanceof Resource) {
            throw new RuntimeException(URI_BLANK_NODE_PROPERTIES);
        }
        Literal oldLiteral = (Literal)this.rawVertex;
        if (key.equals("type") || key.equals("lang")) {
            this.rawVertex = new LiteralImpl(oldLiteral.getLabel());
            this.updateLiteral(oldLiteral, (Literal)this.rawVertex);
        }
        if (key.equals("type")) {
            return oldLiteral.getDatatype().toString();
        }
        if (key.equals("lang")) {
            return oldLiteral.getLanguage();
        }
        return null;
    }

    public Object getProperty(String key) {
        if (key.equals("kind")) {
            if (this.rawVertex instanceof Literal) {
                return "literal";
            }
            if (this.rawVertex instanceof URI) {
                return "uri";
            }
            return "bnode";
        }
        if (this.rawVertex instanceof Literal) {
            Literal literal = (Literal)this.rawVertex;
            if (key.equals("type")) {
                if (null != literal.getDatatype()) {
                    return literal.getDatatype().stringValue();
                }
                return null;
            }
            if (key.equals("lang")) {
                return literal.getLanguage();
            }
            if (key.equals("value")) {
                return SailVertex.castLiteral(literal);
            }
        }
        return null;
    }

    public Set<String> getPropertyKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (this.rawVertex instanceof Literal) {
            if (null != this.getProperty("type")) {
                keys.add("type");
            } else if (null != this.getProperty("lang")) {
                keys.add("lang");
            }
            keys.add("value");
        }
        keys.add("kind");
        return keys;
    }

    public Iterable<Edge> getOutEdges(String ... labels) {
        if (this.rawVertex instanceof Resource) {
            try {
                if (labels.length == 0) {
                    return new SailEdgeSequence((CloseableIteration<? extends Statement, SailException>)this.graph.getSailConnection().get().getStatements((Resource)this.rawVertex, null, null, false, new Resource[0]), this.graph);
                }
                if (labels.length == 1) {
                    return new SailEdgeSequence((CloseableIteration<? extends Statement, SailException>)this.graph.getSailConnection().get().getStatements((Resource)this.rawVertex, (URI)new URIImpl(this.graph.expandPrefix(labels[0])), null, false, new Resource[0]), this.graph);
                }
                ArrayList<SailEdgeSequence> edges = new ArrayList<SailEdgeSequence>();
                for (String label : labels) {
                    edges.add(new SailEdgeSequence((CloseableIteration<? extends Statement, SailException>)this.graph.getSailConnection().get().getStatements((Resource)this.rawVertex, (URI)new URIImpl(this.graph.expandPrefix(label)), null, false, new Resource[0]), this.graph));
                }
                return new MultiIterable(edges);
            }
            catch (SailException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return new SailEdgeSequence();
    }

    public Iterable<Edge> getInEdges(String ... labels) {
        try {
            if (labels.length == 0) {
                return new SailEdgeSequence((CloseableIteration<? extends Statement, SailException>)this.graph.getSailConnection().get().getStatements(null, null, this.rawVertex, false, new Resource[0]), this.graph);
            }
            if (labels.length == 1) {
                return new SailEdgeSequence((CloseableIteration<? extends Statement, SailException>)this.graph.getSailConnection().get().getStatements(null, (URI)new URIImpl(this.graph.expandPrefix(labels[0])), (Value)((Resource)this.rawVertex), false, new Resource[0]), this.graph);
            }
            ArrayList<SailEdgeSequence> edges = new ArrayList<SailEdgeSequence>();
            for (String label : labels) {
                edges.add(new SailEdgeSequence((CloseableIteration<? extends Statement, SailException>)this.graph.getSailConnection().get().getStatements(null, (URI)new URIImpl(this.graph.expandPrefix(label)), (Value)((Resource)this.rawVertex), false, new Resource[0]), this.graph));
            }
            return new MultiIterable(edges);
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Query query() {
        return new DefaultQuery((Vertex)this);
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    protected static Object castLiteral(Literal literal) {
        if (null != literal.getDatatype()) {
            String className = dataTypeToClass.get(literal.getDatatype().stringValue());
            if (null == className) {
                return literal.getLabel();
            }
            try {
                Class<?> c = Class.forName(className);
                if (c == String.class) {
                    return literal.getLabel();
                }
                if (c == Float.class) {
                    return Float.valueOf(literal.getLabel());
                }
                if (c == Integer.class) {
                    return Integer.valueOf(literal.getLabel());
                }
                if (c == Double.class) {
                    return Double.valueOf(literal.getLabel());
                }
                return literal.getLabel();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return literal.getLabel();
            }
        }
        return literal.getLabel();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof SailVertex && ((SailVertex)object).getId().equals(this.getId());
    }

    public Object getId() {
        return this.rawVertex.toString();
    }

    static {
        dataTypeToClass.put("http://www.w3.org/2001/XMLSchema#string", "java.lang.String");
        dataTypeToClass.put("http://www.w3.org/2001/XMLSchema#int", "java.lang.Integer");
        dataTypeToClass.put("http://www.w3.org/2001/XMLSchema#integer", "java.lang.Integer");
        dataTypeToClass.put("http://www.w3.org/2001/XMLSchema#float", "java.lang.Float");
        dataTypeToClass.put("http://www.w3.org/2001/XMLSchema#double", "java.lang.Double");
    }
}

