/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.sail.util;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.impls.sail.SailEdge;
import com.tinkerpop.blueprints.pgm.impls.sail.SailGraph;
import info.aduna.iteration.CloseableIteration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openrdf.model.Statement;
import org.openrdf.sail.SailException;

public class SailEdgeSequence
implements Iterable<Edge>,
Iterator<Edge> {
    private final CloseableIteration<? extends Statement, SailException> statements;
    private final SailGraph graph;

    public SailEdgeSequence(CloseableIteration<? extends Statement, SailException> statements, SailGraph graph) {
        this.statements = statements;
        this.graph = graph;
    }

    public SailEdgeSequence() {
        this.statements = null;
        this.graph = null;
    }

    @Override
    public Iterator<Edge> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (null == this.statements) {
            return false;
        }
        try {
            if (this.statements.hasNext()) {
                return true;
            }
            this.statements.close();
            return false;
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Edge next() {
        if (null == this.statements) {
            throw new NoSuchElementException();
        }
        try {
            return new SailEdge((Statement)this.statements.next(), this.graph);
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchElementException e) {
            try {
                this.statements.close();
            }
            catch (SailException e2) {
                throw new RuntimeException(e2.getMessage(), e2);
            }
            throw e;
        }
    }
}

