/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class OClientConnection {
    public int id;
    public ONetworkProtocol protocol;
    public long since;
    public ODatabaseDocumentTx database;
    public ODatabaseRaw rawDatabase;
    public ONetworkProtocolData data = new ONetworkProtocolData();
    public List<ORecordInternal<?>> records2Push = new ArrayList();

    public OClientConnection(int iId, ONetworkProtocol iProtocol) throws IOException {
        this.id = iId;
        this.protocol = iProtocol;
        this.since = System.currentTimeMillis();
    }

    public void close() {
        if (this.database != null) {
            this.database.close();
            this.database = null;
        }
        this.records2Push.clear();
    }

    public String toString() {
        return "OClientConnection [id=" + this.id + ", source=" + (this.protocol != null && this.protocol.getChannel() != null ? this.protocol.getChannel().socket.getRemoteSocketAddress() : "?") + ", since=" + this.since + "]";
    }

    public String getRemoteAddress() {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.protocol.getChannel().socket.getRemoteSocketAddress();
        return String.valueOf(remoteAddress.getAddress().getHostAddress()) + ":" + remoteAddress.getPort();
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OClientConnection other = (OClientConnection)obj;
        return this.id == other.id;
    }

    public OChannelBinary getChannel() {
        return (OChannelBinary)this.protocol.getChannel();
    }

    public ONetworkProtocol getProtocol() {
        return this.protocol;
    }
}

