/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.memory.OStorageMemory;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.OServerShutdownHook;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerConfigurationLoaderXml;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkProtocolConfiguration;
import com.orientechnologies.orient.server.config.OServerStorageConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.handler.OServerHandler;
import com.orientechnologies.orient.server.managed.OrientServer;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class OServer {
    protected ReentrantLock lock = new ReentrantLock();
    protected volatile boolean running = true;
    protected OServerConfigurationLoaderXml configurationLoader;
    protected OServerConfiguration configuration;
    protected OContextConfiguration contextConfiguration;
    protected OServerShutdownHook shutdownHook;
    protected List<OServerHandler> handlers = new ArrayList<OServerHandler>();
    protected Map<String, Class<? extends ONetworkProtocol>> protocols = new HashMap<String, Class<? extends ONetworkProtocol>>();
    protected List<OServerNetworkListener> listeners = new ArrayList<OServerNetworkListener>();
    protected static ThreadGroup threadGroup;
    private OrientServer managedServer;
    private ObjectName onProfiler = new ObjectName("OrientDB:type=Profiler");
    private ObjectName onServer = new ObjectName("OrientDB:type=Server");
    private final CountDownLatch startupLatch = new CountDownLatch(1);
    private Random random = new Random();

    public OServer() throws ClassNotFoundException, MalformedObjectNameException, NullPointerException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.defaultSettings();
        OLogManager.installCustomFormatter();
        threadGroup = new ThreadGroup("OrientDB Server");
        OGlobalConfiguration.STORAGE_KEEP_OPEN.setValue((Object)true);
        System.setProperty("com.sun.management.jmxremote", "true");
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        mBeanServer.registerMBean(OProfiler.getInstance().startRecording(), this.onProfiler);
        this.managedServer = new OrientServer();
        mBeanServer.registerMBean(this.managedServer, this.onServer);
        this.shutdownHook = new OServerShutdownHook();
    }

    public void startup() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        String config = "config/orientdb-server-config.xml";
        if (System.getProperty("orientdb.config.file") != null) {
            config = System.getProperty("orientdb.config.file");
        }
        this.startup(new File(config));
    }

    public void startup(File iConfigurationFile) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        this.startup(this.loadConfigurationFromFile(iConfigurationFile));
    }

    public void startup(String iConfiguration) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IOException {
        this.startup(new ByteArrayInputStream(iConfiguration.getBytes()));
    }

    public void startup(InputStream iInputStream) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IOException {
        this.configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, iInputStream);
        this.configuration = this.configurationLoader.load();
        this.startup(this.configuration);
    }

    public void startup(OServerConfiguration iConfiguration) throws IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        OLogManager.instance().info((Object)this, "OrientDB Server v" + OConstants.getVersion() + " is starting up...", new Object[0]);
        Orient.instance();
        this.loadConfiguration(iConfiguration);
    }

    public void activate() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (OServerNetworkProtocolConfiguration p : this.configuration.network.protocols) {
            this.protocols.put(p.name, Class.forName(p.implementation));
        }
        for (OServerNetworkListenerConfiguration l : this.configuration.network.listeners) {
            this.listeners.add(new OServerNetworkListener(this, l.ipAddress, l.portRange, l.protocol, this.protocols.get(l.protocol), l.parameters, l.commands));
        }
        this.registerHandlers();
        OLogManager.instance().info((Object)this, "OrientDB Server v1.0 is active.", new Object[0]);
        this.startupLatch.countDown();
    }

    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.shutdownHook.cancel();
        OLogManager.instance().info((Object)this, "OrientDB Server is shutdowning...", new Object[0]);
        try {
            Orient.instance().shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.lock.lock();
            if (this.handlers.size() > 0) {
                OLogManager.instance().info((Object)this, "Shutdowning handlers:", new Object[0]);
                for (OServerHandler h : this.handlers) {
                    OLogManager.instance().info((Object)this, "- %s", new Object[]{h.getName()});
                    try {
                        h.sendShutdown();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (this.protocols.size() > 0) {
                OLogManager.instance().info((Object)this, "Shutdowning protocols", new Object[0]);
                this.protocols.clear();
            }
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                mBeanServer.unregisterMBean(this.onProfiler);
                mBeanServer.unregisterMBean(this.onServer);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "OrientDB Server v1.0 unregisterMBean error.", (Throwable)e, new Object[0]);
            }
            if (this.listeners.size() > 0) {
                OLogManager.instance().info((Object)this, "Shutdowning listeners:", new Object[0]);
                for (OServerNetworkListener l : this.listeners) {
                    OLogManager.instance().info((Object)this, "- %s", new Object[]{l});
                    try {
                        l.shutdown();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        OLogManager.instance().info((Object)this, "OrientDB Server shutdown complete", new Object[0]);
        System.out.println();
    }

    public String getStoragePath(String iName) {
        String name = iName.indexOf(58) > -1 ? iName.substring(iName.indexOf(58) + 1) : iName;
        OStorage stg = Orient.instance().getStorage(name);
        if (stg != null) {
            return stg.getURL();
        }
        String dbPath = this.configuration.getStoragePath(name);
        if (dbPath == null) {
            dbPath = OSystemVariableResolver.resolveSystemVariables((String)("${ORIENTDB_HOME}/databases/" + name + "/"));
            File f = new File(String.valueOf(dbPath) + "default.odh");
            if (!f.exists()) {
                throw new OConfigurationException("Database '" + name + "' is not configured on server");
            }
            dbPath = "local:${ORIENTDB_HOME}/databases/" + name;
        }
        return dbPath;
    }

    public Map<String, String> getAvailableStorageNames() {
        HashMap<String, String> storages = new HashMap<String, String>();
        if (this.configuration.storages != null && this.configuration.storages.length > 0) {
            OServerStorageConfiguration[] oServerStorageConfigurationArray = this.configuration.storages;
            int n = this.configuration.storages.length;
            int n2 = 0;
            while (n2 < n) {
                OServerStorageConfiguration s = oServerStorageConfigurationArray[n2];
                storages.put(s.name, s.path);
                ++n2;
            }
        }
        String rootDirectory = this.getDatabaseDirectory();
        this.scanDatabaseDirectory(rootDirectory, new File(rootDirectory), storages);
        for (OStorage storage : Orient.instance().getStorages()) {
            String storageName = storage.getName();
            if (storages.containsKey(storageName)) continue;
            storages.put(storageName, storage.getURL());
        }
        return storages;
    }

    public String getDatabaseDirectory() {
        return OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}/databases/");
    }

    public ThreadGroup getServerThreadGroup() {
        return threadGroup;
    }

    public OServerUserConfiguration serverLogin(String iUser, String iPassword, String iResource) {
        if (!this.authenticate(iUser, iPassword, iResource)) {
            throw new OSecurityAccessException("Wrong user/password to [connect] to the remote OrientDB Server instance. Get the user/password from the config/orientdb-server-config.xml file");
        }
        return this.getUser(iUser);
    }

    public boolean authenticate(String iUserName, String iPassword, String iResourceToCheck) {
        OServerUserConfiguration user = this.getUser(iUserName);
        if (user != null && (iPassword == null || user.password.equals(iPassword))) {
            String[] resourceParts;
            if (user.resources.equals("*")) {
                return true;
            }
            String[] stringArray = resourceParts = user.resources.split(",");
            int n = resourceParts.length;
            int n2 = 0;
            while (n2 < n) {
                String r = stringArray[n2];
                if (r.equals(iResourceToCheck)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public OServerUserConfiguration getUser(String iUserName) {
        return this.configuration.getUser(iUserName);
    }

    public boolean existsStoragePath(String iURL) {
        return this.configuration.getStoragePath(iURL) != null;
    }

    public OServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void saveConfiguration() throws IOException {
        this.configurationLoader.save(this.configuration);
    }

    public Map<String, Class<? extends ONetworkProtocol>> getProtocols() {
        return this.protocols;
    }

    public List<OServerNetworkListener> getListeners() {
        return this.listeners;
    }

    public <RET extends OServerNetworkListener> RET getListenerByProtocol(Class<? extends ONetworkProtocol> iProtocolClass) {
        for (OServerNetworkListener l : this.listeners) {
            if (!l.getProtocolType().equals(iProtocolClass)) continue;
            return (RET)l;
        }
        return null;
    }

    public OrientServer getManagedServer() {
        return this.managedServer;
    }

    public List<OServerHandler> getHandlers() {
        return this.handlers;
    }

    public OContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    public <RET extends OServerHandler> RET getHandler(Class<RET> iHandlerClass) {
        try {
            this.startupLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        for (OServerHandler h : this.handlers) {
            if (!h.getClass().equals(iHandlerClass)) continue;
            return (RET)h;
        }
        return null;
    }

    protected void loadConfiguration(OServerConfiguration iConfiguration) {
        try {
            this.configuration = iConfiguration;
            this.contextConfiguration = new OContextConfiguration();
            if (iConfiguration.properties != null) {
                OServerEntryConfiguration[] oServerEntryConfigurationArray = iConfiguration.properties;
                int n = iConfiguration.properties.length;
                int n2 = 0;
                while (n2 < n) {
                    OServerEntryConfiguration prop = oServerEntryConfigurationArray[n2];
                    this.contextConfiguration.setValue(prop.name, (Object)prop.value);
                    ++n2;
                }
            }
            this.loadStorages();
            this.loadUsers();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on reading server configuration.", OConfigurationException.class);
        }
    }

    protected OServerConfiguration loadConfigurationFromFile(File iFile) {
        try {
            this.configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, iFile);
            return this.configurationLoader.load();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on reading server configuration from file: " + iFile, (Throwable)e, OConfigurationException.class, new Object[0]);
            return null;
        }
    }

    protected void loadUsers() throws IOException {
        if (this.configuration.users != null && this.configuration.users.length > 0) {
            OServerUserConfiguration[] oServerUserConfigurationArray = this.configuration.users;
            int n = this.configuration.users.length;
            int n2 = 0;
            while (n2 < n) {
                OServerUserConfiguration u = oServerUserConfigurationArray[n2];
                if (u.name.equals("root")) {
                    return;
                }
                ++n2;
            }
        }
        this.createAdminAndDbListerUsers();
    }

    protected void loadStorages() {
        if (this.configuration.storages == null) {
            return;
        }
        OServerStorageConfiguration[] oServerStorageConfigurationArray = this.configuration.storages;
        int n = this.configuration.storages.length;
        int n2 = 0;
        while (n2 < n) {
            block18: {
                OServerStorageConfiguration stg = oServerStorageConfigurationArray[n2];
                if (stg.loadOnStartup) {
                    if (stg.userName == null) {
                        stg.userName = "admin";
                    }
                    if (stg.userPassword == null) {
                        stg.userPassword = "admin";
                    }
                    String type = stg.path.substring(0, stg.path.indexOf(58));
                    ODatabaseDocumentTx db = null;
                    try {
                        try {
                            db = new ODatabaseDocumentTx(stg.path);
                            if (db.exists()) {
                                db.open(stg.userName, stg.userPassword);
                            } else {
                                db.create();
                                if (stg.userName.equals("admin")) {
                                    if (!stg.userPassword.equals("admin")) {
                                        db.getMetadata().getSecurity().getUser("admin").setPassword(stg.userPassword);
                                    }
                                } else {
                                    db.getMetadata().getSecurity().createUser(stg.userName, stg.userPassword, new String[]{"admin"});
                                    db.getMetadata().getSecurity().dropUser("admin");
                                    db.close();
                                    db.open(stg.userName, stg.userPassword);
                                }
                            }
                            OLogManager.instance().info((Object)this, "-> Loaded " + type + " database '" + stg.name + "'", new Object[0]);
                        }
                        catch (Exception e) {
                            OLogManager.instance().error((Object)this, "-> Cannot load " + type + " database '" + stg.name + "': " + e, new Object[0]);
                            if (db != null) {
                                db.close();
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (db != null) {
                            db.close();
                        }
                        throw throwable;
                    }
                    if (db != null) {
                        db.close();
                    }
                }
            }
            ++n2;
        }
    }

    public void addUser(String iName, String iPassword, String iPermissions) throws IOException {
        if (iName == null || iName.length() == 0) {
            throw new IllegalArgumentException("User name null or empty");
        }
        if (iPermissions == null || iPermissions.length() == 0) {
            throw new IllegalArgumentException("User permissions null or empty");
        }
        this.configuration.users = Arrays.copyOf(this.configuration.users, this.configuration.users.length + 1);
        if (iPassword == null) {
            iPassword = OSecurityManager.instance().digest2String(String.valueOf(this.random.nextLong()), false);
        }
        this.configuration.users[this.configuration.users.length - 1] = new OServerUserConfiguration(iName, iPassword, iPermissions);
        this.saveConfiguration();
    }

    protected void createAdminAndDbListerUsers() throws IOException {
        this.addUser("root", null, "*");
        this.addUser("guest", "guest", "connect,server.listDatabases");
        this.saveConfiguration();
    }

    protected void registerHandlers() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.configuration.handlers != null) {
            for (OServerHandlerConfiguration h : this.configuration.handlers) {
                OServerHandler handler = (OServerHandler)Class.forName(h.clazz).newInstance();
                this.handlers.add(handler);
                handler.config(this, h.parameters);
                handler.startup();
            }
        }
    }

    protected void defaultSettings() {
        OGlobalConfiguration.FILE_LOCK.setValue((Object)true);
        OGlobalConfiguration.TX_USE_LOG.setValue((Object)true);
        OGlobalConfiguration.TX_COMMIT_SYNCH.setValue((Object)true);
    }

    protected void scanDatabaseDirectory(String iRootDirectory, File iDirectory, Map<String, String> iStorages) {
        if (iDirectory.exists() && iDirectory.isDirectory()) {
            File[] fileArray = iDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File db = fileArray[n2];
                if (db.isDirectory()) {
                    File f = new File(String.valueOf(db.getAbsolutePath()) + "/default.odh");
                    if (f.exists()) {
                        String dbPath = db.getPath().replace('\\', '/');
                        iStorages.put(dbPath.substring(iRootDirectory.length()), "local:" + dbPath);
                    } else {
                        this.scanDatabaseDirectory(iRootDirectory, db, iStorages);
                    }
                }
                ++n2;
            }
        }
    }

    public ODatabaseComplex<?> openDatabase(String iDbType, String iDbUrl, String iUser, String iPassword) {
        String path = OServerMain.server().getStoragePath(iDbUrl);
        ODatabaseDocumentTx database = Orient.instance().getDatabaseFactory().createDatabase(iDbType, path);
        if (database.isClosed()) {
            if (database.getStorage() instanceof OStorageMemory) {
                database.create();
            } else {
                try {
                    database.open(iUser, iPassword);
                }
                catch (OSecurityException e) {
                    try {
                        OServerMain.server().serverLogin(iUser, iPassword, "database.passthrough");
                    }
                    catch (OSecurityException ex) {
                        throw e;
                    }
                    database.setProperty(ODatabase.OPTIONS.SECURITY.toString(), (Object)Boolean.FALSE);
                    database.open(iUser, iPassword);
                }
            }
        }
        return database;
    }
}

