/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.clustering;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import java.util.logging.Level;

public class OClusterLogger {
    private String node;
    private String database;
    private static final OLogManager logger = OLogManager.instance();

    public void log(Object iRequester, Level iLevel, TYPE iType, DIRECTION iDirection, String iMessage, Object ... iAdditionalArgs) {
        this.log(iRequester, iLevel, iType, iDirection, iMessage, null, iAdditionalArgs);
    }

    public void log(Object iRequester, Level iLevel, TYPE iType, DIRECTION iDirection, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (logger.isLevelEnabled(iLevel)) {
            logger.log(iRequester, iLevel, this.formatMessage(iType, iDirection, iMessage), iException, iAdditionalArgs);
        }
    }

    public void error(Object iRequester, TYPE iType, DIRECTION iDirection, String iMessage, Throwable iException, Class<? extends OException> iExceptionClass, Object ... iAdditionalArgs) {
        logger.error(iRequester, this.formatMessage(iType, iDirection, iMessage), null, iExceptionClass, iAdditionalArgs);
    }

    public String getNode() {
        return this.node;
    }

    public OClusterLogger setNode(String node) {
        this.node = node;
        return this;
    }

    public String getDatabase() {
        return this.database;
    }

    public OClusterLogger setDatabase(String database) {
        this.database = database;
        return this;
    }

    protected String formatMessage(TYPE iType, DIRECTION iDirection, String iMessage) {
        StringBuilder buffer = new StringBuilder();
        if (iType == TYPE.CLUSTER) {
            buffer.append("CLUS");
        } else if (iType == TYPE.REPLICATION) {
            buffer.append("REPL");
        }
        if (this.node != null) {
            if (iDirection == DIRECTION.IN) {
                buffer.append("<-");
            } else if (iDirection == DIRECTION.OUT) {
                buffer.append("->");
            } else {
                buffer.append("--");
            }
            if (this.node != null) {
                buffer.append('{');
                buffer.append(this.node);
                buffer.append('}');
            }
        }
        if (this.database != null) {
            buffer.append(" (");
            buffer.append(this.database);
            buffer.append(')');
        }
        buffer.append(' ');
        buffer.append(iMessage);
        return buffer.toString();
    }

    public static enum DIRECTION {
        NONE,
        IN,
        OUT;

    }

    public static enum TYPE {
        CLUSTER,
        REPLICATION;

    }
}

