/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.clustering;

import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryInputStream;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.network.protocol.binary.OBinaryNetworkProtocolAbstract;
import com.orientechnologies.orient.server.network.protocol.distributed.OReplicationActiveThreadLocal;
import com.orientechnologies.orient.server.replication.ODistributedDatabaseInfo;
import com.orientechnologies.orient.server.replication.ODistributedNode;
import com.orientechnologies.orient.server.replication.OOperationLog;
import com.orientechnologies.orient.server.replication.conflict.OReplicationConflictException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class OClusterNetworkProtocol
extends OBinaryNetworkProtocolAbstract
implements OCommandOutputListener {
    private ODistributedServerManager manager;
    private String remoteNodeId;
    private String commandInfo;
    private final Map<String, ODatabaseRecord> databases = new HashMap<String, ODatabaseRecord>(5);
    private final OClusterLogger logger = new OClusterLogger();

    public OClusterNetworkProtocol() {
        super("OrientDB <- Node/?");
        this.manager = OServerMain.server().getHandler(ODistributedServerManager.class);
        if (this.manager == null) {
            throw new OConfigurationException("Cannot find a ODistributedServerDiscoveryManager instance registered as handler. Check the server configuration in the handlers section.");
        }
    }

    @Override
    public void config(OServer iServer, Socket iSocket, OContextConfiguration iConfig) throws IOException {
        super.config(iServer, iSocket, iConfig);
        this.channel.writeShort((short)0);
        this.channel.flush();
        this.start();
    }

    @Override
    protected boolean executeRequest() throws IOException {
        switch (this.requestType) {
            case 100: {
                this.commandInfo = "Connection from node";
                this.remoteNodeId = this.channel.readString();
                this.logger.setNode(this.remoteNodeId);
                this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "connected, authenticating it...", new Object[0]);
                this.setName("OrientDB <- Node/" + this.remoteNodeId);
                String userName = this.channel.readString();
                this.serverUser = OServerMain.server().serverLogin(userName, this.channel.readString(), "connect");
                this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "authenticated correctly with user '%s'", userName);
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                    break;
                }
                finally {
                    this.endResponse();
                }
            }
            case 101: {
                this.commandInfo = "Connection from leader";
                ODocument doc = new ODocument().fromStream(this.channel.readBytes());
                String clusterName = (String)doc.field("clusterName");
                byte[] encodedSecurityKey = (byte[])doc.field("clusterKey");
                String leaderAddress = (String)doc.field("leaderNodeAddress");
                this.logger.setNode(leaderAddress);
                if (!clusterName.equals(this.manager.getName()) || !Arrays.equals(encodedSecurityKey, this.manager.getConfig().getSecurityKey())) {
                    throw new OSecurityException("Invalid combination of cluster name and key received");
                }
                boolean remainTheLeader = false;
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                    if (this.manager.isLeader()) {
                        this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "received remote connection from the leader, but current node is itself leader: split network problem or high network latency?", new Object[0]);
                        String myUid = String.valueOf(InetAddress.getLocalHost().getHostAddress()) + ":" + this.channel.socket.getLocalPort();
                        if (leaderAddress.compareTo(myUid) > 0) {
                            remainTheLeader = true;
                            this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.NONE, "current node remains the Leader of the cluster because it has lower network address", new Object[0]);
                        }
                    }
                    this.channel.writeByte((byte)(!remainTheLeader ? 1 : 0));
                    if (!remainTheLeader) {
                        ODocument localCfg = this.manager.getReplicator().getLocalDatabaseConfiguration();
                        this.channel.writeBytes(localCfg.toStream());
                    }
                }
                finally {
                    this.endResponse();
                }
                if (remainTheLeader) {
                    this.sendShutdown();
                    break;
                }
                this.setName("OrientDB <- Distributed Leader");
                this.manager.becomePeer(this);
                this.manager.getReplicator().updateConfiguration(new ODocument(this.channel.readBytes()));
                break;
            }
            case 102: {
                this.checkConnected();
                this.commandInfo = "Cluster Heartbeat";
                long lastInterval = this.manager.updateHeartBeatTime();
                this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "heartbeat. Last msg was %dms ago", lastInterval);
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                    break;
                }
                finally {
                    this.endResponse();
                }
            }
            case 104: {
                this.commandInfo = "Synchronization between nodes";
                String dbName = this.channel.readString();
                ODocument cfg = new ODocument(this.channel.readBytes());
                this.logger.setDatabase(dbName);
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "received synchronization request", new Object[0]);
                ODatabaseRecord db = this.getOrOpenDatabase(dbName);
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                }
                finally {
                    this.endResponse();
                }
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "opening a connection back...", new Object[0]);
                this.manager.getReplicator().connect(this.remoteNodeId, dbName, ODistributedDatabaseInfo.SYNCH_TYPE.ASYNCH.toString());
                ODistributedNode replicationNode = this.manager.getReplicator().getNode(this.remoteNodeId);
                this.manager.getReplicator().getConflictResolver().init((ODatabaseComplex<?>)db);
                ORecordOperation op = new ORecordOperation();
                Collection nodes = (Collection)cfg.field("nodes");
                int sent = 0;
                for (ODocument nodeCfg : nodes) {
                    int position;
                    String node = (String)nodeCfg.field("node");
                    long lastLog = (Long)nodeCfg.field("lastLog");
                    this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "reading operation for node %s logs after %d", node, lastLog);
                    OOperationLog opLog = this.manager.getReplicator().getOperationLog(node, dbName);
                    if (opLog == null || (position = opLog.findOperationId(lastLog)) <= -1) continue;
                    int totalToSend = opLog.totalEntries();
                    int i = position;
                    while (i < totalToSend) {
                        opLog.getEntry(i, op);
                        try {
                            replicationNode.propagateChange(op, ODistributedDatabaseInfo.SYNCH_TYPE.SYNCH, false);
                            this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "#%d operation %d with RID %s", ++sent, op.serial, op.record.getIdentity());
                        }
                        catch (OSerializationException e) {
                            this.logger.log((Object)this, Level.SEVERE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "#%d cannot be transmitted, log entry %d, record %s: ", sent, op.serial, op.record.getIdentity(), e.getCause());
                        }
                        catch (RuntimeException e) {
                            this.logger.log((Object)this, Level.SEVERE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "#%d cannot be transmitted, log entry %d, record %s", e, sent, op.serial, op.record.getIdentity());
                            throw e;
                        }
                        ++i;
                    }
                }
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "starting inverse replication...", new Object[0]);
                this.manager.getReplicator().startReplication(this.remoteNodeId, dbName, ODistributedDatabaseInfo.SYNCH_TYPE.ASYNCH.toString());
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "synchronization completed", new Object[0]);
                break;
            }
            case 107: {
                this.commandInfo = "Alignment between nodes";
                ODocument cfg = new ODocument(this.channel.readBytes());
                String dbName = (String)cfg.field("db");
                ODocument block = (ODocument)cfg.field("block");
                this.logger.setDatabase(dbName);
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "received alignment request", new Object[0]);
                ODatabaseRecord db = this.getOrOpenDatabase(dbName);
                OStorage storage = db.getStorage();
                ODistributedNode remoteNode = this.manager.getReplicator().getNode(this.remoteNodeId);
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                }
                finally {
                    this.endResponse();
                }
                ORecordId rid = new ORecordId();
                String[] lastLog = block.fieldNames();
                int n = lastLog.length;
                int n2 = 0;
                while (n2 < n) {
                    String ridAsString = lastLog[n2];
                    rid.fromString(ridAsString.replace('_', ':'));
                    ORawBuffer localRecord = storage.readRecord(rid, null, false, null);
                    int remoteVersion = (Integer)block.field(ridAsString);
                    if (localRecord.version == -1) {
                        if (remoteVersion > -1) {
                            remoteNode.propagateChange(new ORecordOperation((OIdentifiable)rid, 2), ODistributedDatabaseInfo.SYNCH_TYPE.SYNCH, false);
                        }
                    } else if (remoteVersion == -1) {
                        if (localRecord.version > -1) {
                            db.delete((ORID)rid);
                        }
                    } else if (localRecord.version > remoteVersion) {
                        this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "Sending record %s to remote: my version %d > remote %d", rid, localRecord.version, remoteVersion);
                        remoteNode.propagateChange(new ORecordOperation((OIdentifiable)rid, 1), ODistributedDatabaseInfo.SYNCH_TYPE.SYNCH, false);
                    } else if (localRecord.version < remoteVersion) {
                        this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "Getting remote record %s: its version %d > mine %d", rid, remoteVersion, localRecord.version);
                        remoteNode.requestRecord(dbName, rid);
                    }
                    ++n2;
                }
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "alignment completed for %d", block.fields());
                break;
            }
            case 106: {
                this.commandInfo = "Retrieve record";
                String dbName = this.channel.readString();
                ORecordId rid = this.channel.readRID();
                this.logger.setNode(dbName);
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "record %s...", rid);
                ODatabaseRecord database = this.getOrOpenDatabase(dbName);
                ORecordInternal record = (ORecordInternal)database.load((ORID)rid);
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                    if (record != null) {
                        this.channel.writeByte(record.getRecordType());
                        this.channel.writeInt(record.getVersion());
                        this.channel.writeBytes(record.toStream());
                        break;
                    }
                    this.channel.writeByte((byte)-1);
                    break;
                }
                finally {
                    this.endResponse();
                }
            }
            case 105: {
                long result;
                this.commandInfo = "Distributed record change";
                String dbName = this.channel.readString();
                byte operationType = this.channel.readByte();
                long operationId = this.channel.readLong();
                ORecordId rid = this.channel.readRID();
                byte[] buffer = this.channel.readBytes();
                int version = this.channel.readInt() - 1;
                byte recordType = this.channel.readByte();
                this.logger.setNode(dbName);
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "%s record %s...", ORecordOperation.getName((int)operationType), rid);
                ODatabaseRecord database = this.getOrOpenDatabase(dbName);
                OReplicationActiveThreadLocal.INSTANCE.set(false);
                try {
                    switch (operationType) {
                        case 3: {
                            long origClusterPosition = rid.clusterPosition;
                            rid.clusterPosition = -1L;
                            result = this.createRecord(database, rid, buffer, recordType, 0).getIdentity().getClusterPosition();
                            if (result != origClusterPosition) {
                                throw new OReplicationConflictException("Remote record has RID different by the original", (ORID)rid, (ORID)new ORecordId(rid.clusterId, result));
                            }
                            rid.clusterPosition = result;
                            break;
                        }
                        case 1: {
                            result = this.updateRecord(database, rid, buffer, version, recordType);
                            break;
                        }
                        case 2: {
                            result = this.deleteRecord(database, (ORID)rid, version);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Received invalid distributed record change operation type: " + operationType);
                        }
                    }
                }
                finally {
                    OReplicationActiveThreadLocal.INSTANCE.set(true);
                }
                ODistributedNode node = this.manager.getReplicator().getNode(this.remoteNodeId);
                ODistributedDatabaseInfo db = node.getDatabase(database.getName());
                db.getLog().appendLog(operationId, operationType, rid);
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                    this.channel.writeLong(result);
                    break;
                }
                finally {
                    this.endResponse();
                }
            }
            case 103: {
                this.checkConnected();
                this.commandInfo = "Importing a database from a remote node";
                String dbName = this.channel.readString();
                String dbUser = this.channel.readString();
                String dbPasswd = this.channel.readString();
                String dbType = this.channel.readString();
                String engineType = this.channel.readString();
                try {
                    this.logger.setNode(dbName);
                    this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "importing database...", new Object[0]);
                    ODatabaseDocumentTx database = this.getDatabaseInstance(dbName, dbType, engineType);
                    if (database.exists()) {
                        this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.NONE, "deleting existent database...", database.getName());
                        database.drop();
                        this.manager.getReplicator().resetAnyPreviousReplicationLog(dbName);
                    }
                    if ((database = this.createDatabase(database, dbUser, dbPasswd)).isClosed()) {
                        database.open(dbUser, dbPasswd);
                    }
                    this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "reading database content via streaming from remote server node...", new Object[0]);
                    this.beginResponse();
                    try {
                        OReplicationActiveThreadLocal.INSTANCE.set(false);
                        new ODatabaseImport((ODatabaseDocument)database, (InputStream)new OChannelBinaryInputStream((OChannelBinary)this.channel), (OCommandOutputListener)this).importDatabase();
                        this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "database imported correctly", new Object[0]);
                        this.sendOk(this.clientTxId);
                    }
                    finally {
                        OReplicationActiveThreadLocal.INSTANCE.set(true);
                        this.endResponse();
                    }
                }
                finally {
                    this.manager.getPeer().updateHeartBeatTime();
                }
                this.manager.getPeer().updateConfigurationToLeader();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected ODatabaseRecord getOrOpenDatabase(String dbName) {
        ODatabaseRecord db = this.databases.get(dbName);
        if (db == null) {
            db = (ODatabaseDocumentTx)OServerMain.server().openDatabase("document", dbName, this.serverUser.name, this.serverUser.password);
            this.databases.put(dbName, db);
        }
        ODatabaseRecordThreadLocal.INSTANCE.set((Object)db);
        return db;
    }

    private void beginResponse() {
        this.channel.acquireExclusiveLock();
    }

    private void endResponse() throws IOException {
        this.channel.flush();
        this.channel.releaseExclusiveLock();
    }

    public void onMessage(String iText) {
    }

    @Override
    public String getType() {
        return "cluster";
    }

    protected void checkConnected() {
    }
}

