/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.clustering.leader;

import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.enterprise.channel.binary.OAsynchChannelServiceThread;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.clustering.leader.OLeaderNode;
import com.orientechnologies.orient.server.clustering.leader.ORemoteNodeAbstract;
import com.orientechnologies.orient.server.replication.ODistributedRemoteAsynchEventListener;
import java.io.IOException;
import java.util.logging.Level;
import javax.crypto.SecretKey;

public class ORemotePeer
extends ORemoteNodeAbstract {
    private OLeaderNode leader;
    private OContextConfiguration configuration;
    private volatile STATUS status = STATUS.DISCONNECTED;

    public ORemotePeer(OLeaderNode iNode, String iServerAddress, int iServerPort) {
        super(iServerAddress, iServerPort);
        this.leader = iNode;
        this.configuration = new OContextConfiguration();
        this.setStatus(STATUS.CONNECTING);
        this.logger.setNode(iServerAddress);
    }

    @Override
    protected void connect() throws IOException {
    }

    public boolean connect(int iTimeout, String iClusterName, SecretKey iSecurityKey) throws IOException {
        ODocument cfg;
        this.configuration.setValue(OGlobalConfiguration.NETWORK_SOCKET_TIMEOUT, (Object)iTimeout);
        this.channel = new OChannelBinaryClient(this.networkAddress, this.networkPort, this.configuration, 0);
        this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "received joining request from peer node. Checking authorizations...", new Object[0]);
        this.channel.writeByte((byte)101);
        this.channel.writeInt(0);
        ODocument doc = new ODocument();
        doc.field("clusterName", (Object)iClusterName);
        doc.field("clusterKey", (Object)iSecurityKey.getEncoded());
        doc.field("leaderNodeAddress", (Object)this.leader.getManager().getId());
        doc.field("leaderNodeRunningSince", (Object)this.leader.getManager().getRunningSince());
        this.channel.writeBytes(doc.toStream());
        this.channel.flush();
        this.beginResponse();
        try {
            byte connectedAsPeer = this.channel.readByte();
            if (connectedAsPeer == 0) {
                this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "remote server node has refused the connection because it's the new Leader. Switching to be a Peer Node...", new Object[0]);
                this.leader.getManager().becomePeer(null);
                this.disconnect();
                return false;
            }
            this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "joined peer node", new Object[0]);
            cfg = new ODocument().fromStream(this.channel.readBytes());
        }
        finally {
            this.endResponse();
        }
        ODocument answer = this.leader.updatePeerDatabases(this.id, cfg);
        this.channel.writeBytes(answer.toStream());
        this.channel.flush();
        this.setStatus(STATUS.CONNECTED);
        this.serviceThread = new OAsynchChannelServiceThread((ORemoteServerEventListener)new ODistributedRemoteAsynchEventListener(this.leader.getManager(), null, this.id), this.channel, "OrientDB <- Asynch Node/" + this.id);
        return true;
    }

    public boolean sendHeartBeat(int iNetworkTimeout) throws InterruptedException {
        if (this.channel == null) {
            return false;
        }
        if (this.status != STATUS.CONNECTED) {
            return false;
        }
        this.configuration.setValue(OGlobalConfiguration.NETWORK_SOCKET_TIMEOUT, (Object)iNetworkTimeout);
        this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.OUT, "Sending heartbeat message...", new Object[0]);
        try {
            this.channel.beginRequest();
            try {
                this.channel.writeByte((byte)102);
                this.channel.writeInt(0);
            }
            finally {
                this.channel.endRequest();
            }
            this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "Waiting for the heartbeat response...", new Object[0]);
            this.channel.beginResponse(0, 2000L);
            this.channel.endResponse();
            this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "Received heartbeat ACK", new Object[0]);
        }
        catch (Exception e) {
            this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.OUT, "Error on sending heartbeat to server node", e, new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean checkConnection() {
        boolean connected = super.checkConnection();
        if (!connected) {
            this.setStatus(STATUS.DISCONNECTED);
        }
        return connected;
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.setStatus(STATUS.DISCONNECTED);
    }

    public STATUS getStatus() {
        return this.status;
    }

    private void setStatus(STATUS iStatus) {
        this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.NONE, "peer changed status %s -> %s", new Object[]{this.status, iStatus});
        this.status = iStatus;
    }

    public static enum STATUS {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        UNREACHABLE,
        SYNCHRONIZING;

    }
}

