/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.clustering.peer;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryServer;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.clustering.OClusterNetworkProtocol;
import com.orientechnologies.orient.server.clustering.peer.OLeaderCheckerTask;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import java.io.IOException;
import java.util.TimerTask;
import java.util.logging.Level;

public class OPeerNode {
    private final ODistributedServerManager manager;
    private OLeaderCheckerTask leaderCheckerTask;
    private long lastHeartBeat;
    private OClusterNetworkProtocol leaderConnection;
    private OClusterLogger logger = new OClusterLogger();

    public OPeerNode(ODistributedServerManager iManager, OClusterNetworkProtocol iConnection) {
        this.manager = iManager;
        this.leaderConnection = iConnection;
        this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "joined cluster <%s> as peer node", iManager.getConfig().name);
        this.leaderCheckerTask = new OLeaderCheckerTask(this);
        Orient.getTimer().schedule((TimerTask)this.leaderCheckerTask, this.manager.getConfig().networkHeartbeatDelay, (long)(this.manager.getConfig().networkHeartbeatDelay / 2));
        this.updateHeartBeatTime();
    }

    public void shutdown() {
        if (this.leaderCheckerTask != null) {
            this.leaderCheckerTask.cancel();
            this.leaderCheckerTask = null;
        }
    }

    public long getLastHeartBeat() {
        return this.lastHeartBeat;
    }

    public long updateHeartBeatTime() {
        long now = System.currentTimeMillis();
        long lastInterval = now - this.lastHeartBeat;
        this.lastHeartBeat = now;
        return lastInterval;
    }

    public ODistributedServerManager getManager() {
        return this.manager;
    }

    public void updateConfigurationToLeader() throws IOException {
        if (this.manager.isLeader()) {
            return;
        }
        this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.OUT, "Sending cluster configuration to leader", new Object[0]);
        ODocument doc = new ODocument();
        doc.field("availableDatabases", (Object)this.manager.getReplicator().getLocalDatabaseConfiguration());
        OChannelBinaryServer channel = (OChannelBinaryServer)this.leaderConnection.getChannel();
        channel.acquireExclusiveLock();
        try {
            channel.writeByte((byte)3);
            channel.writeInt(Integer.MIN_VALUE);
            channel.writeByte((byte)127);
            channel.writeBytes(doc.toStream());
            channel.flush();
        }
        finally {
            channel.releaseExclusiveLock();
        }
        this.manager.getReplicator().updateConfiguration(new ODocument(channel.readBytes()));
    }
}

