/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OVariableParser;
import com.orientechnologies.common.parser.OVariableParserListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.handler.OServerHandlerAbstract;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;

public class OAutomaticBackup
extends OServerHandlerAbstract {
    private long delay = -1L;
    private String targetDirectory = "backup";
    private String targetFileName;
    private Set<String> includeDatabases = new HashSet<String>();
    private Set<String> excludeDatabases = new HashSet<String>();

    @Override
    public void config(OServer iServer, OServerParameterConfiguration[] iParams) {
        File filePath;
        OServerParameterConfiguration[] oServerParameterConfigurationArray = iParams;
        int n = iParams.length;
        int n2 = 0;
        while (n2 < n) {
            String db;
            int n3;
            int n4;
            String[] stringArray;
            OServerParameterConfiguration param = oServerParameterConfigurationArray[n2];
            if (param.name.equalsIgnoreCase("enabled")) {
                if (!Boolean.parseBoolean(param.value)) {
                    return;
                }
            } else if (param.name.equalsIgnoreCase("delay")) {
                this.delay = OIOUtils.getTimeAsMillisecs((Object)param.value);
            } else if (param.name.equalsIgnoreCase("target.directory")) {
                this.targetDirectory = param.value;
            } else if (param.name.equalsIgnoreCase("db.include") && param.value.trim().length() > 0) {
                stringArray = param.value.split(",");
                n4 = stringArray.length;
                n3 = 0;
                while (n3 < n4) {
                    db = stringArray[n3];
                    this.includeDatabases.add(db);
                    ++n3;
                }
            } else if (param.name.equalsIgnoreCase("db.exclude") && param.value.trim().length() > 0) {
                stringArray = param.value.split(",");
                n4 = stringArray.length;
                n3 = 0;
                while (n3 < n4) {
                    db = stringArray[n3];
                    this.excludeDatabases.add(db);
                    ++n3;
                }
            } else if (param.name.equalsIgnoreCase("target.fileName")) {
                this.targetFileName = param.value;
            }
            ++n2;
        }
        if (this.delay <= 0L) {
            throw new OConfigurationException("Cannot find mandatory parameter 'delay'");
        }
        if (!this.targetDirectory.endsWith("/")) {
            this.targetDirectory = String.valueOf(this.targetDirectory) + "/";
        }
        if ((filePath = new File(this.targetDirectory)).exists()) {
            if (!filePath.isDirectory()) {
                throw new OConfigurationException("Parameter 'path' points to a file, not a directory");
            }
        } else {
            filePath.mkdirs();
        }
        OLogManager.instance().info((Object)this, "Automatic backup handler installed and active: delay=%dms, targetDirectory=%s", new Object[]{this.delay, this.targetDirectory});
        Orient.getTimer().schedule(new TimerTask(){

            @Override
            public void run() {
                OLogManager.instance().info((Object)this, "[OAutomaticBackup] Scanning databases to backup...", new Object[0]);
                int ok = 0;
                int errors = 0;
                Map<String, String> databaseNames = OServerMain.server().getAvailableStorageNames();
                for (final Map.Entry<String, String> dbName : databaseNames.entrySet()) {
                    boolean include = OAutomaticBackup.this.includeDatabases.size() > 0 ? OAutomaticBackup.this.includeDatabases.contains(dbName.getKey()) : true;
                    if (OAutomaticBackup.this.excludeDatabases.contains(dbName.getKey())) {
                        include = false;
                    }
                    if (!include) continue;
                    String fileName = OVariableParser.resolveVariables((String)OAutomaticBackup.this.targetFileName, (String)"${", (String)"}", (OVariableParserListener)new OVariableParserListener(){

                        public String resolve(String iVariable) {
                            if (iVariable.equalsIgnoreCase(VARIABLES.DBNAME.toString())) {
                                return (String)dbName.getKey();
                            }
                            if (iVariable.startsWith(VARIABLES.DATE.toString())) {
                                return new SimpleDateFormat(iVariable.substring(VARIABLES.DATE.toString().length() + 1)).format(new Date());
                            }
                            throw new IllegalArgumentException("Variable '" + iVariable + "' wasn't found");
                        }
                    });
                    String exportFilePath = String.valueOf(OAutomaticBackup.this.targetDirectory) + fileName;
                    ODatabaseDocumentTx db = new ODatabaseDocumentTx(dbName.getValue());
                    try {
                        try {
                            db.setProperty(ODatabase.OPTIONS.SECURITY.toString(), (Object)Boolean.FALSE);
                            db.open("admin", "aaa");
                            long begin = System.currentTimeMillis();
                            new ODatabaseExport((ODatabaseRecord)db, exportFilePath, new OCommandOutputListener(){

                                public void onMessage(String iText) {
                                }
                            }).exportDatabase();
                            OLogManager.instance().info((Object)this, "[OAutomaticBackup] - Backup of database '" + dbName.getValue() + "' completed in " + (System.currentTimeMillis() - begin) + "ms", new Object[0]);
                            ++ok;
                        }
                        catch (IOException e) {
                            OLogManager.instance().error((Object)this, "[OAutomaticBackup] - Error on exporting database '" + dbName.getValue() + "' to file: " + exportFilePath, (Throwable)e, new Object[0]);
                            ++errors;
                            db.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        db.close();
                        throw throwable;
                    }
                    db.close();
                }
                OLogManager.instance().info((Object)this, "[OAutomaticBackup] Backup finished: %d ok, %d errors", new Object[]{ok, errors});
            }
        }, this.delay, this.delay);
    }

    public String getName() {
        return "automaticBackup";
    }

    public static enum VARIABLES {
        DBNAME,
        DATE;

    }
}

