/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;

public class OServerNetworkListener
extends Thread {
    private ServerSocket serverSocket;
    private InetSocketAddress inboundAddr;
    private Class<? extends ONetworkProtocol> protocolType;
    private volatile boolean active = true;
    private OServerCommand[] commands;
    private int socketBufferSize;
    private OContextConfiguration configuration;
    private OServer server;

    public OServerNetworkListener(OServer iServer, String iHostName, String iHostPortRange, String iProtocolName, Class<? extends ONetworkProtocol> iProtocol, OServerParameterConfiguration[] iParameters, OServerCommandConfiguration[] iCommands) {
        super(Orient.getThreadGroup(), "OrientDB " + iProtocol.getSimpleName() + " listen at " + iHostName + ":" + iHostPortRange);
        this.server = iServer;
        this.listen(iHostName, iHostPortRange, iProtocolName);
        this.protocolType = iProtocol;
        this.readParameters(iServer.getContextConfiguration(), iParameters);
        if (iCommands != null) {
            this.commands = new OServerCommand[iCommands.length];
            int i = 0;
            while (i < iCommands.length) {
                try {
                    Constructor<?> c = Class.forName(iCommands[i].implementation).getConstructor(OServerCommandConfiguration.class);
                    this.commands[i] = (OServerCommand)c.newInstance(iCommands[i]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot create custom command '" + iCommands[i] + "'", e);
                }
                ++i;
            }
        }
        this.start();
    }

    public void shutdown() {
        this.active = false;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void listen(String iHostName, String iHostPortRange, String iProtocolName) {
        int[] ports;
        int[] nArray = ports = OServerNetworkListener.getPorts(iHostPortRange);
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            int port = nArray[n2];
            this.inboundAddr = new InetSocketAddress(iHostName, port);
            try {
                this.serverSocket = new ServerSocket(port, 0, InetAddress.getByName(iHostName));
                if (this.serverSocket.isBound()) {
                    OLogManager.instance().info((Object)this, "Listening " + iProtocolName + " connections on " + this.inboundAddr.getHostName() + ":" + this.inboundAddr.getPort(), new Object[0]);
                    return;
                }
            }
            catch (BindException be) {
                OLogManager.instance().info((Object)this, "Port %s:%d busy, trying the next available...", new Object[]{iHostName, port});
            }
            catch (SocketException se) {
                OLogManager.instance().error((Object)this, "Unable to create socket", (Throwable)se, new Object[0]);
                System.exit(1);
            }
            catch (IOException ioe) {
                OLogManager.instance().error((Object)this, "Unable to read data from an open socket", (Throwable)ioe, new Object[0]);
                System.err.println("Unable to read data from an open socket.");
                System.exit(1);
            }
            ++n2;
        }
        OLogManager.instance().error((Object)this, "Unable to listen for connections using the configured ports '%s' on host '%s'", new Object[]{iHostPortRange, iHostName});
        System.exit(1);
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Class<? extends ONetworkProtocol> getProtocolType() {
        return this.protocolType;
    }

    public InetSocketAddress getInboundAddr() {
        return this.inboundAddr;
    }

    private void readParameters(OContextConfiguration iServerConfig, OServerParameterConfiguration[] iParameters) {
        this.configuration = new OContextConfiguration(iServerConfig);
        if (iParameters != null && iParameters.length > 0) {
            OServerParameterConfiguration[] oServerParameterConfigurationArray = iParameters;
            int n = iParameters.length;
            int n2 = 0;
            while (n2 < n) {
                OServerParameterConfiguration param = oServerParameterConfigurationArray[n2];
                this.configuration.setValue(param.name, (Object)param.value);
                ++n2;
            }
        }
        this.socketBufferSize = this.configuration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_BUFFER_SIZE);
    }

    public static int[] getPorts(String iHostPortRange) {
        int[] ports;
        if (OStringSerializerHelper.contains((String)iHostPortRange, (char)',')) {
            String[] portValues = iHostPortRange.split(",");
            ports = new int[portValues.length];
            int i = 0;
            while (i < portValues.length) {
                ports[i] = Integer.parseInt(portValues[i]);
                ++i;
            }
        } else if (OStringSerializerHelper.contains((String)iHostPortRange, (char)'-')) {
            String[] limits = iHostPortRange.split("-");
            int lowerLimit = Integer.parseInt(limits[0]);
            int upperLimit = Integer.parseInt(limits[1]);
            ports = new int[upperLimit - lowerLimit + 1];
            int i = 0;
            while (i < upperLimit - lowerLimit + 1) {
                ports[i] = lowerLimit + i;
                ++i;
            }
        } else {
            ports = new int[]{Integer.parseInt(iHostPortRange)};
        }
        return ports;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.protocolType.getSimpleName()).append(" ").append(this.serverSocket.getLocalSocketAddress()).append(":");
        return builder.toString();
    }
}

