/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequestException;
import com.orientechnologies.orient.server.network.protocol.http.OHttpUtils;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class OServerCommandAbstract
implements OServerCommand {
    protected static final String JSON_FORMAT = "type,indent:2,rid,version,attribSameRow,class";
    private static final char[] URL_SEPARATOR = new char[]{'/'};

    @Override
    public boolean beforeExecute(OHttpRequest iRequest) throws IOException {
        return true;
    }

    protected void sendTextContent(OHttpRequest iRequest, int iCode, String iReason, String iHeaders, String iContentType, Object iContent) throws IOException {
        this.sendTextContent(iRequest, iCode, iReason, iHeaders, iContentType, iContent, true);
    }

    protected void sendTextContent(OHttpRequest iRequest, int iCode, String iReason, String iHeaders, String iContentType, Object iContent, boolean iKeepAlive) throws IOException {
        String contentType;
        String content;
        if (iRequest.url.indexOf(63) > 0 && iRequest.url.indexOf("callback=", iRequest.url.indexOf(63)) > 0) {
            String callbackFunction = iRequest.url.substring(iRequest.url.indexOf("callback=", iRequest.url.indexOf(63)) + "callback=".length());
            if (callbackFunction.indexOf(38) > -1) {
                callbackFunction = callbackFunction.substring(0, callbackFunction.indexOf(38));
            }
            content = String.valueOf(callbackFunction) + "(" + iContent + ")";
            contentType = "text/javascript";
        } else {
            content = iContent != null ? iContent.toString() : null;
            contentType = iContentType;
        }
        boolean empty = content == null || content.length() == 0;
        this.sendStatus(iRequest, empty && iCode == 200 ? 204 : iCode, iReason);
        this.sendResponseHeaders(iRequest, contentType, iKeepAlive);
        if (iHeaders != null) {
            this.writeLine(iRequest, iHeaders);
        }
        String sessId = iRequest.sessionId != null ? iRequest.sessionId : "-";
        this.writeLine(iRequest, "Set-Cookie: OSESSIONID=" + sessId + "; Path=/; HttpOnly");
        byte[] binaryContent = empty ? null : OBinaryProtocol.string2bytes((String)content);
        this.writeLine(iRequest, "Content-Length: " + (empty ? 0 : binaryContent.length));
        this.writeLine(iRequest, null);
        if (binaryContent != null) {
            iRequest.channel.outStream.write(binaryContent);
        }
        iRequest.channel.flush();
    }

    protected void sendStatus(OHttpRequest iRequest, int iStatus, String iReason) throws IOException {
        this.writeLine(iRequest, String.valueOf(iRequest.httpVersion) + " " + iStatus + " " + iReason);
    }

    protected void sendResponseHeaders(OHttpRequest iRequest, String iContentType) throws IOException {
        this.sendResponseHeaders(iRequest, iContentType, true);
    }

    protected void sendResponseHeaders(OHttpRequest iRequest, String iContentType, boolean iKeepAlive) throws IOException {
        this.onBeforeResponseHeader(iRequest);
        this.writeLine(iRequest, "Date: " + new Date());
        this.writeLine(iRequest, "Content-Type: " + iContentType + "; charset=" + iRequest.executor.getResponseCharSet());
        this.writeLine(iRequest, "Server: " + iRequest.data.serverInfo);
        this.writeLine(iRequest, "Connection: " + (iKeepAlive ? "Keep-Alive" : "close"));
        this.onAfterResponseHeader(iRequest);
    }

    protected void onBeforeResponseHeader(OHttpRequest iRequest) throws IOException {
        this.writeLine(iRequest, "Cache-Control: no-cache, no-store, max-age=0, must-revalidate\r\nPragma: no-cache");
    }

    protected void onAfterResponseHeader(OHttpRequest iRequest) throws IOException {
    }

    protected void writeLine(OHttpRequest iRequest, String iContent) throws IOException {
        this.writeContent(iRequest, iContent);
        iRequest.channel.outStream.write(OHttpUtils.EOL);
    }

    protected void writeContent(OHttpRequest iRequest, String iContent) throws IOException {
        if (iContent != null) {
            iRequest.channel.outStream.write(OBinaryProtocol.string2bytes((String)iContent));
        }
    }

    protected Map<String, String> getParameters(OHttpRequest iRequest) {
        int begin = iRequest.url.indexOf("?");
        if (begin > -1) {
            String[] paramPairs;
            HashMap<String, String> params = new HashMap<String, String>();
            String parameters = iRequest.url.substring(begin + 1);
            String[] stringArray = paramPairs = parameters.split("&");
            int n = paramPairs.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                String[] parts = p.split("=");
                if (parts.length == 2) {
                    params.put(parts[0], parts[1]);
                }
                ++n2;
            }
            return params;
        }
        return Collections.emptyMap();
    }

    protected String[] checkSyntax(String iURL, int iArgumentCount, String iSyntax) {
        List parts;
        int parametersPos = iURL.indexOf(63);
        if (parametersPos > -1) {
            iURL = iURL.substring(0, parametersPos);
        }
        if ((parts = OStringSerializerHelper.smartSplit((String)iURL, (char[])URL_SEPARATOR, (int)1, (int)-1, (boolean)true, (char[])new char[0])).size() < iArgumentCount) {
            throw new OHttpRequestException(iSyntax);
        }
        String[] array = new String[parts.size()];
        return parts.toArray(array);
    }

    protected void sendRecordsContent(OHttpRequest iRequest, List<OIdentifiable> iRecords) throws IOException {
        this.sendRecordsContent(iRequest, iRecords, null);
    }

    protected void sendRecordsContent(OHttpRequest iRequest, List<OIdentifiable> iRecords, String iFetchPlan) throws IOException {
        StringWriter buffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)buffer, JSON_FORMAT);
        json.beginObject();
        String format = iFetchPlan != null ? "type,indent:2,rid,version,attribSameRow,class,fetchPlan:" + iFetchPlan : JSON_FORMAT;
        json.beginCollection(1, true, "result");
        this.formatCollection(iRecords, buffer, format);
        json.endCollection(1, true);
        json.endObject();
        this.sendTextContent(iRequest, 200, "OK", null, "application/json", buffer.toString());
    }

    protected void formatCollection(List<OIdentifiable> iRecords, StringWriter buffer, String format) {
        if (iRecords != null) {
            int counter = 0;
            for (OIdentifiable rec : iRecords) {
                if (rec == null) continue;
                try {
                    String objectJson = rec.getRecord().toJSON(format);
                    if (counter++ > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(objectJson);
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error transforming record " + rec.getIdentity() + " to JSON", (Throwable)e, new Object[0]);
                }
            }
        }
    }

    protected void sendRecordContent(OHttpRequest iRequest, ORecord<?> iRecord) throws IOException {
        this.sendRecordContent(iRequest, iRecord, null);
    }

    protected void sendRecordContent(OHttpRequest iRequest, ORecord<?> iRecord, String iFetchPlan) throws IOException {
        String format;
        String string = format = iFetchPlan != null ? "type,indent:2,rid,version,attribSameRow,class,fetchPlan:" + iFetchPlan : JSON_FORMAT;
        if (iRecord != null) {
            this.sendTextContent(iRequest, 200, "OK", null, "application/json", iRecord.toJSON(format));
        }
    }

    protected void sendBinaryContent(OHttpRequest iRequest, int iCode, String iReason, String iContentType, InputStream iContent, long iSize) throws IOException {
        this.sendStatus(iRequest, iCode, iReason);
        this.sendResponseHeaders(iRequest, iContentType);
        this.writeLine(iRequest, "Content-Length: " + iSize);
        this.writeLine(iRequest, null);
        if (iContent != null) {
            int b;
            while ((b = iContent.read()) > -1) {
                iRequest.channel.outStream.write(b);
            }
        }
        iRequest.channel.flush();
    }

    public void exportClassSchema(ODatabaseRecord db, OJSONWriter json, OClass cls) throws IOException {
        if (cls == null) {
            return;
        }
        json.write(" \"schema\": ");
        json.beginObject(1, false, null);
        json.writeAttribute(2, true, "name", (Object)cls.getName());
        if (cls.properties() != null && cls.properties().size() > 0) {
            json.beginObject(2, true, (Object)"properties");
            for (OProperty prop : cls.properties()) {
                json.beginObject(3, true, (Object)prop.getName());
                json.writeAttribute(4, true, "name", (Object)prop.getName());
                if (prop.getLinkedClass() != null) {
                    json.writeAttribute(4, true, "linkedClass", (Object)prop.getLinkedClass().getName());
                }
                if (prop.getLinkedType() != null) {
                    json.writeAttribute(4, true, "linkedType", (Object)prop.getLinkedType().toString());
                }
                json.writeAttribute(4, true, "type", (Object)prop.getType().toString());
                json.writeAttribute(4, true, "mandatory", (Object)prop.isMandatory());
                json.writeAttribute(4, true, "notNull", (Object)prop.isNotNull());
                json.writeAttribute(4, true, "min", (Object)prop.getMin());
                json.writeAttribute(4, true, "max", (Object)prop.getMax());
                json.endObject(3, true);
            }
            json.endObject(2, true);
        }
        json.endObject(1, true);
    }

    protected String nextChainUrl(String iCurrentUrl) {
        if (!iCurrentUrl.contains("/")) {
            return iCurrentUrl;
        }
        return iCurrentUrl.startsWith("/") ? iCurrentUrl.substring(iCurrentUrl.indexOf(47, 1)) : iCurrentUrl.substring(iCurrentUrl.indexOf("/"));
    }
}

