/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequestException;
import com.orientechnologies.orient.server.network.protocol.http.OHttpSessionManager;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAbstract;
import java.io.IOException;
import java.util.List;

public abstract class OServerCommandAuthenticatedDbAbstract
extends OServerCommandAbstract {
    public static final char DBNAME_DIR_SEPARATOR = '$';
    public static final String SESSIONID_UNAUTHORIZED = "-";
    public static final String SESSIONID_LOGOUT = "!";

    @Override
    public boolean beforeExecute(OHttpRequest iRequest) throws IOException {
        String[] urlParts = iRequest.url.substring(1).split("/");
        if (urlParts.length < 2) {
            throw new OHttpRequestException("Syntax error in URL. Expected is: <command>/<database>[/...]");
        }
        iRequest.databaseName = urlParts[1];
        iRequest.databaseName = iRequest.databaseName.replace('$', '/');
        if (iRequest.sessionId == null || iRequest.sessionId != null && iRequest.sessionId.length() == 1) {
            if (iRequest.authorization == null || SESSIONID_LOGOUT.equals(iRequest.sessionId)) {
                this.sendAuthorizationRequest(iRequest, iRequest.databaseName);
                return false;
            }
            return this.authenticate(iRequest, iRequest.databaseName);
        }
        if (iRequest.sessionId.length() > 1 && OHttpSessionManager.getInstance().getSession(iRequest.sessionId) == null) {
            this.sendAuthorizationRequest(iRequest, iRequest.databaseName);
            return false;
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean authenticate(OHttpRequest iRequest, String iDatabaseName) throws IOException {
        block10: {
            ODatabaseDocumentTx db = null;
            try {
                List parts = OStringSerializerHelper.split((String)iRequest.authorization, (char)':', (char[])new char[0]);
                db = OSharedDocumentDatabase.acquire(iDatabaseName, (String)parts.get(0), (String)parts.get(1));
                iRequest.sessionId = OHttpSessionManager.getInstance().createSession(iDatabaseName, (String)parts.get(0));
                if (db == null) break block10;
            }
            catch (OSecurityAccessException parts) {
                if (db != null) {
                    OSharedDocumentDatabase.release(db);
                    return false;
                }
                this.sendAuthorizationRequest(iRequest, iDatabaseName);
                return false;
                catch (OLockException e) {
                    block11: {
                        OLogManager.instance().error((Object)this, "Cannot access to the database '" + iDatabaseName + "'", new Object[]{ODatabaseException.class, e});
                        if (db == null) break block11;
                        {
                            catch (Throwable throwable) {
                                if (db != null) {
                                    OSharedDocumentDatabase.release(db);
                                    throw throwable;
                                }
                                this.sendAuthorizationRequest(iRequest, iDatabaseName);
                                throw throwable;
                            }
                        }
                        OSharedDocumentDatabase.release(db);
                        return false;
                    }
                    this.sendAuthorizationRequest(iRequest, iDatabaseName);
                    return false;
                    catch (InterruptedException e2) {
                        block12: {
                            Thread.currentThread().interrupt();
                            OLogManager.instance().error((Object)this, "Cannot access to the database '" + iDatabaseName + "'", new Object[]{ODatabaseException.class, e2});
                            if (db == null) break block12;
                            OSharedDocumentDatabase.release(db);
                            return false;
                        }
                        this.sendAuthorizationRequest(iRequest, iDatabaseName);
                        return false;
                    }
                }
            }
            OSharedDocumentDatabase.release(db);
            return true;
        }
        this.sendAuthorizationRequest(iRequest, iDatabaseName);
        return true;
    }

    protected void sendAuthorizationRequest(OHttpRequest iRequest, String iDatabaseName) throws IOException {
        iRequest.sessionId = SESSIONID_UNAUTHORIZED;
        this.sendTextContent(iRequest, 401, "Unauthorized", "WWW-Authenticate: Basic realm=\"OrientDB db-" + iDatabaseName + "\"", "text/plain", "401 Unauthorized.", false);
    }

    protected ODatabaseDocumentTx getProfiledDatabaseInstance(OHttpRequest iRequest) throws InterruptedException {
        if (iRequest.authorization == null) {
            throw new OSecurityAccessException(iRequest.databaseName, "No user and password received");
        }
        List parts = OStringSerializerHelper.split((String)iRequest.authorization, (char)':', (char[])new char[0]);
        return OSharedDocumentDatabase.acquire(iRequest.databaseName, (String)parts.get(0), (String)parts.get(1));
    }
}

