/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command;

import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAbstract;
import java.io.IOException;

public abstract class OServerCommandAuthenticatedServerAbstract
extends OServerCommandAbstract {
    private static final String SESSIONID_UNAUTHORIZED = "-";
    private static final String SESSIONID_LOGOUT = "!";
    private final String resource;

    protected OServerCommandAuthenticatedServerAbstract(String iRequiredResource) {
        this.resource = iRequiredResource;
    }

    @Override
    public boolean beforeExecute(OHttpRequest iRequest) throws IOException {
        return this.authenticate(iRequest, true);
    }

    protected boolean authenticate(OHttpRequest iRequest, boolean iAskForAuthentication) throws IOException {
        String[] authParts;
        if (this.checkGuestAccess()) {
            return true;
        }
        if (iAskForAuthentication && (iRequest.authorization == null || SESSIONID_LOGOUT.equals(iRequest.sessionId))) {
            this.sendAuthorizationRequest(iRequest);
            return false;
        }
        if (iRequest.authorization != null && (authParts = iRequest.authorization.split(":")).length == 2 && OServerMain.server().authenticate(authParts[0], authParts[1], this.resource)) {
            return true;
        }
        this.sendNotAuthorizedResponse(iRequest);
        return false;
    }

    protected boolean checkGuestAccess() {
        return OServerMain.server().authenticate("guest", null, this.resource);
    }

    protected void sendNotAuthorizedResponse(OHttpRequest iRequest) throws IOException {
        iRequest.sessionId = SESSIONID_UNAUTHORIZED;
        this.sendTextContent(iRequest, 403, "Forbidden", "WWW-Authenticate: Basic realm=\"OrientDB Server\"", "text/plain", "403 Forbidden.", false);
    }

    protected void sendAuthorizationRequest(OHttpRequest iRequest) throws IOException {
        iRequest.sessionId = SESSIONID_UNAUTHORIZED;
        this.sendTextContent(iRequest, 401, "Unauthorized", "WWW-Authenticate: Basic realm=\"OrientDB Server\"", "text/plain", "401 Unauthorized.", false);
    }
}

