/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.all;

import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAbstract;

public class OServerCommandForward
extends OServerCommandAbstract {
    private final String[] pattern;
    private final String prefix;
    private String forwardTo;

    public OServerCommandForward(OServerCommandConfiguration iConfiguration) {
        this.pattern = new String[]{iConfiguration.pattern};
        this.prefix = iConfiguration.pattern.substring(iConfiguration.pattern.indexOf("|") + 1);
        OServerEntryConfiguration[] oServerEntryConfigurationArray = iConfiguration.parameters;
        int n = iConfiguration.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            OServerEntryConfiguration par = oServerEntryConfigurationArray[n2];
            if (par.name.equals("to")) {
                this.forwardTo = par.value;
            }
            ++n2;
        }
    }

    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        int prefixLength;
        int postfix;
        StringBuilder forwardURL = new StringBuilder("/");
        forwardURL.append(this.forwardTo);
        if (this.prefix.endsWith("*") && (postfix = iRequest.url.indexOf(this.prefix.substring(0, prefixLength = this.prefix.length() - 1))) > -1) {
            forwardURL.append(iRequest.url.substring(postfix + prefixLength));
        }
        iRequest.url = forwardURL.toString();
        return true;
    }

    @Override
    public String[] getNames() {
        return this.pattern;
    }
}

