/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.delete;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;

public class OServerCommandDeleteIndex
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"DELETE|index/*"};

    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: index/<database>/<index-name>/<key>/[<value>]");
        iRequest.data.commandInfo = "Index remove";
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            OIndex index = db.getMetadata().getIndexManager().getIndex(urlParts[2]);
            if (index == null) {
                throw new IllegalArgumentException("Index name '" + urlParts[2] + "' not found");
            }
            boolean found = urlParts.length > 4 ? index.remove((Object)urlParts[3], (OIdentifiable)new ORecordId(urlParts[3])) : index.remove((Object)urlParts[3]);
            if (found) {
                this.sendTextContent(iRequest, 200, "OK", null, "text/plain", null);
            } else {
                this.sendTextContent(iRequest, 404, "Not Found", null, "text/plain", null);
            }
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

