/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.delete;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;

public class OServerCommandDeleteProperty
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"DELETE|property/*"};

    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 4, "Syntax error: property/<database>/<class-name>/<property-name>");
        iRequest.data.commandInfo = "Delete property";
        iRequest.data.commandDetail = String.valueOf(urlParts[2]) + "." + urlParts[3];
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            if (db.getMetadata().getSchema().getClass(urlParts[2]) == null) {
                throw new IllegalArgumentException("Invalid class '" + urlParts[2] + "'");
            }
            OClass cls = db.getMetadata().getSchema().getClass(urlParts[2]);
            cls.dropProperty(urlParts[3]);
            this.sendTextContent(iRequest, 200, "OK", null, "text/plain", null);
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

