/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.delete;

import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;

public class OServerCommandDropDatabase
extends OServerCommandAuthenticatedServerAbstract {
    private static final String[] NAMES = new String[]{"DELETE|database/*"};

    public OServerCommandDropDatabase() {
        super("database.drop");
    }

    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: database/<database>");
        iRequest.data.commandInfo = "Drop database";
        iRequest.data.commandDetail = urlParts[1];
        Object db = null;
        try {
            if (!OSharedDocumentDatabase.getDatabasePools().containsKey(urlParts[1])) {
                throw new IllegalArgumentException("Invalid database '" + urlParts[1] + "'");
            }
            throw new UnsupportedOperationException("Drop database");
        }
        catch (Throwable throwable) {
            if (db != null) {
                db.close();
            }
            throw throwable;
        }
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

