/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;

public class OServerCommandGetClass
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|class/*"};

    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: class/<database>/<class-name>[/<limit>]<br/>Limit is optional and is setted to 20 by default. Set expressely to 0 to have no limits.");
        iRequest.data.commandInfo = "Browse class";
        iRequest.data.commandDetail = urlParts[2];
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            if (db.getMetadata().getSchema().getClass(urlParts[2]) == null) {
                throw new IllegalArgumentException("Invalid class '" + urlParts[2] + "'");
            }
            int limit = urlParts.length > 3 ? Integer.parseInt(urlParts[3]) : 20;
            ArrayList<OIdentifiable> response = new ArrayList<OIdentifiable>();
            for (ORecord rec : db.browseClass(urlParts[2])) {
                if (limit > 0 && response.size() >= limit) break;
                response.add((OIdentifiable)rec);
            }
            if (response != null && response.size() > 0) {
                this.sendRecordsContent(iRequest, response);
            } else {
                StringWriter buffer = new StringWriter();
                OJSONWriter json = new OJSONWriter((Writer)buffer, "type,indent:2,rid,version,attribSameRow,class");
                json.beginObject();
                this.exportClassSchema((ODatabaseRecord)db, json, db.getMetadata().getSchema().getClass(urlParts[2]));
                json.endObject();
                this.sendTextContent(iRequest, 200, "OK", null, "application/json", buffer.toString());
            }
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

