/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;

public class OServerCommandGetDictionary
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|dictionary/*"};

    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        iRequest.data.commandInfo = "Dictionary lookup";
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: dictionary/<database>/<key>");
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            ORecord record = (ORecord)db.getDictionary().get(urlParts[2]);
            if (record == null) {
                throw new ORecordNotFoundException("Key '" + urlParts[2] + "' was not found in the database dictionary");
            }
            this.sendRecordContent(iRequest, record);
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

