/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;

public class OServerCommandGetDocument
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|document/*"};

    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        ORecordInternal rec;
        ODatabaseDocumentTx db = null;
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: document/<database>/<record-id>[/fetchPlan]");
        String fetchPlan = urlParts.length > 3 ? urlParts[3] : null;
        iRequest.data.commandInfo = "Load document";
        int parametersPos = urlParts[2].indexOf(63);
        String rid = parametersPos > -1 ? urlParts[2].substring(0, parametersPos) : urlParts[2];
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            rec = db.load((ORID)new ORecordId(rid), fetchPlan);
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        if (rec == null) {
            this.sendTextContent(iRequest, 404, "Not Found", null, "application/json", "Record with id '" + urlParts[2] + "' was not found.");
        } else {
            this.sendRecordContent(iRequest, (ORecord<?>)rec, fetchPlan);
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

