/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class OServerCommandGetServer
extends OServerCommandAuthenticatedServerAbstract {
    private static final String[] NAMES = new String[]{"GET|server"};
    private static final DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    public OServerCommandGetServer() {
        super("server.info");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        OProfiler.OProfilerEntry pEntry;
        OStorage[] storages;
        Object[] objectArray;
        OClientConnection[] conns;
        this.checkSyntax(iRequest.url, 1, "Syntax error: server");
        iRequest.data.commandInfo = "Server status";
        StringWriter jsonBuffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)jsonBuffer);
        json.beginObject();
        json.beginCollection(1, true, "connections");
        OClientConnection[] oClientConnectionArray = conns = OServerMain.server().getManagedServer().getConnections();
        int n = conns.length;
        int n2 = 0;
        while (n2 < n) {
            OClientConnection c = oClientConnectionArray[n2];
            ONetworkProtocolData data = c.data;
            objectArray = dateTimeFormat;
            // MONITORENTER : dateTimeFormat
            String lastCommandOn = dateTimeFormat.format(new Date(data.lastCommandReceived));
            String connectedOn = dateTimeFormat.format(new Date(c.since));
            // MONITOREXIT : objectArray
            json.beginObject(2);
            this.writeField(json, 2, "connectionId", c.id);
            this.writeField(json, 2, "remoteAddress", c.protocol.getChannel() != null ? c.protocol.getChannel().toString() : "Disconnected");
            this.writeField(json, 2, "db", c.database != null ? c.database.getName() : "-");
            this.writeField(json, 2, "user", c.database != null && c.database.getUser() != null ? c.database.getUser().getName() : "-");
            this.writeField(json, 2, "totalRequests", data.totalRequests);
            this.writeField(json, 2, "commandInfo", data.commandInfo);
            this.writeField(json, 2, "commandDetail", data.commandDetail);
            this.writeField(json, 2, "lastCommandOn", lastCommandOn);
            this.writeField(json, 2, "lastCommandInfo", data.lastCommandInfo);
            this.writeField(json, 2, "lastCommandDetail", data.lastCommandDetail);
            this.writeField(json, 2, "lastExecutionTime", data.lastCommandExecutionTime);
            this.writeField(json, 2, "totalWorkingTime", data.totalCommandExecutionTime);
            this.writeField(json, 2, "connectedOn", connectedOn);
            this.writeField(json, 2, "protocol", c.protocol.getType());
            this.writeField(json, 2, "clientId", data.clientId);
            StringBuilder driver = new StringBuilder();
            if (data.driverName != null) {
                driver.append(data.driverName);
                driver.append(" v");
                driver.append(data.driverVersion);
                driver.append(" Protocol v");
                driver.append(data.protocolVersion);
            }
            this.writeField(json, 2, "driver", driver.toString());
            json.endObject(2);
            ++n2;
        }
        json.endCollection(1, false);
        json.beginCollection(1, true, "dbs");
        Map<String, OResourcePool<String, ODatabaseDocumentTx>> dbPool = OSharedDocumentDatabase.getDatabasePools();
        for (Map.Entry<String, OResourcePool<String, ODatabaseDocumentTx>> entry : dbPool.entrySet()) {
            for (ODatabaseDocumentTx db : entry.getValue().getResources()) {
                json.beginObject(2);
                this.writeField(json, 2, "db", db.getName());
                this.writeField(json, 2, "user", db.getUser() != null ? db.getUser().getName() : "-");
                this.writeField(json, 2, "open", db.isClosed() ? "closed" : "open");
                this.writeField(json, 2, "storage", db.getStorage().getClass().getSimpleName());
                json.endObject(2);
            }
        }
        json.endCollection(1, false);
        json.beginCollection(1, true, "storages");
        objectArray = storages = OServerMain.server().getManagedServer().getOpenedStorages();
        int n3 = storages.length;
        int db = 0;
        while (db < n3) {
            OStorage s = objectArray[db];
            json.beginObject(2);
            this.writeField(json, 2, "name", s.getName());
            this.writeField(json, 2, "type", s.getClass().getSimpleName());
            this.writeField(json, 2, "path", s instanceof OStorageLocal ? ((OStorageLocal)s).getStoragePath().replace('\\', '/') : "");
            this.writeField(json, 2, "activeUsers", s.getUsers());
            json.endObject(2);
            ++db;
        }
        json.endCollection(1, false);
        json.beginCollection(2, true, "properties");
        objectArray = OServerMain.server().getConfiguration().properties;
        n3 = OServerMain.server().getConfiguration().properties.length;
        db = 0;
        while (db < n3) {
            OStorage entry = objectArray[db];
            json.beginObject(3, true, null);
            json.writeAttribute(4, false, "name", (Object)entry.name);
            json.writeAttribute(4, false, "value", (Object)entry.value);
            json.endObject(3, true);
            ++db;
        }
        json.endCollection(2, true);
        json.beginObject(1, true, (Object)"profiler");
        json.beginCollection(2, true, "hookValues");
        for (String h : OProfiler.getInstance().getHooks()) {
            json.beginObject(3);
            this.writeField(json, 3, "name", h);
            this.writeField(json, 3, "value", OProfiler.getInstance().getHookValue(h));
            json.endObject(3);
        }
        json.endCollection(2, false);
        json.beginCollection(2, true, "counters");
        for (String c : OProfiler.getInstance().getCounters()) {
            json.beginObject(3);
            this.writeField(json, 3, "name", c);
            this.writeField(json, 3, "value", OProfiler.getInstance().getCounter(c));
            json.endObject(3);
        }
        json.endCollection(2, false);
        json.beginCollection(2, true, "stats");
        for (String s : OProfiler.getInstance().getStats()) {
            pEntry = OProfiler.getInstance().getStat(s);
            json.beginObject(3);
            this.writeField(json, 3, "name", s);
            this.writeField(json, 3, "total", pEntry.items);
            this.writeField(json, 3, "averageElapsed", pEntry.average);
            this.writeField(json, 3, "minElapsed", pEntry.min);
            this.writeField(json, 3, "maxElapsed", pEntry.max);
            this.writeField(json, 3, "lastElapsed", pEntry.last);
            this.writeField(json, 3, "totalElapsed", pEntry.total);
            json.endObject(3);
        }
        json.endCollection(2, false);
        json.beginCollection(2, true, "chronos");
        for (String c : OProfiler.getInstance().getChronos()) {
            pEntry = OProfiler.getInstance().getChrono(c);
            json.beginObject(3);
            this.writeField(json, 3, "name", c);
            this.writeField(json, 3, "total", pEntry.items);
            this.writeField(json, 3, "averageElapsed", pEntry.average);
            this.writeField(json, 3, "minElapsed", pEntry.min);
            this.writeField(json, 3, "maxElapsed", pEntry.max);
            this.writeField(json, 3, "lastElapsed", pEntry.last);
            this.writeField(json, 3, "totalElapsed", pEntry.total);
            json.endObject(3);
        }
        json.endCollection(2, false);
        json.endObject(1);
        json.endObject();
        this.sendTextContent(iRequest, 200, "OK", null, "application/json", jsonBuffer.toString());
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    private void writeField(OJSONWriter json, int iLevel, String iAttributeName, Object iAttributeValue) throws IOException {
        json.writeAttribute(iLevel, true, iAttributeName, (Object)(iAttributeValue != null ? iAttributeValue.toString() : "-"));
    }
}

