/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandConfigurableAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OStaticContentCachedEntry;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class OServerCommandGetStaticContent
extends OServerCommandConfigurableAbstract {
    private static final String[] DEF_PATTERN = new String[]{"GET|www", "GET|studio/", "GET|", "GET|*.htm", "GET|*.html", "GET|*.xml", "GET|*.jpeg", "GET|*.jpg", "GET|*.png", "GET|*.gif", "GET|*.js", "GET|*.otf", "GET|*.css", "GET|*.swf", "GET|favicon.ico", "GET|robots.txt"};
    private static final String CONFIG_HTTP_CACHE = "http.cache:";
    private static final String CONFIG_ROOT_PATH = "root.path";
    private static final String CONFIG_FILE_PATH = "file.path";
    private Map<String, OStaticContentCachedEntry> cacheContents;
    private Map<String, String> cacheHttp = new HashMap<String, String>();
    private String cacheHttpDefault = "Cache-Control: max-age=3000";
    private String rootPath;
    private String filePath;

    public OServerCommandGetStaticContent() {
        super(DEF_PATTERN);
    }

    public OServerCommandGetStaticContent(OServerCommandConfiguration iConfiguration) {
        super(iConfiguration.pattern);
        OServerEntryConfiguration[] oServerEntryConfigurationArray = iConfiguration.parameters;
        int n = iConfiguration.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            OServerEntryConfiguration par = oServerEntryConfigurationArray[n2];
            if (par.name.startsWith(CONFIG_HTTP_CACHE)) {
                String filter = par.name.substring(CONFIG_HTTP_CACHE.length());
                if (filter.equalsIgnoreCase("default")) {
                    this.cacheHttpDefault = par.value;
                } else if (filter.length() > 0) {
                    String[] filters;
                    String[] stringArray = filters = filter.split(" ");
                    int n3 = filters.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String f = stringArray[n4];
                        this.cacheHttp.put(f, par.value);
                        ++n4;
                    }
                }
            } else if (par.name.startsWith(CONFIG_ROOT_PATH)) {
                this.rootPath = par.value;
            } else if (par.name.startsWith(CONFIG_FILE_PATH)) {
                this.filePath = par.value;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        iRequest.data.commandInfo = "Get static content";
        iRequest.data.commandDetail = iRequest.url;
        if (this.filePath == null && this.rootPath == null) {
            this.rootPath = iRequest.configuration.getValueAsString("orientdb.www.path", "src/site");
            if (this.rootPath == null) {
                OLogManager.instance().warn((Object)this, "No path configured. Specify the 'root.path', 'file.path' or the global 'orientdb.www.path' variable", new Object[]{this.rootPath});
                return false;
            }
        }
        if (this.filePath == null) {
            wwwPathDirectory = new File(this.rootPath);
            if (!wwwPathDirectory.exists()) {
                OLogManager.instance().warn((Object)this, "path variable points to '%s' but it doesn't exists", new Object[]{this.rootPath});
            }
            if (!wwwPathDirectory.isDirectory()) {
                OLogManager.instance().warn((Object)this, "path variable points to '%s' but it isn't a directory", new Object[]{this.rootPath});
            }
        }
        if (this.cacheContents == null && OGlobalConfiguration.SERVER_CACHE_FILE_STATIC.getValueAsBoolean()) {
            this.cacheContents = new HashMap<String, OStaticContentCachedEntry>();
        }
        is = null;
        contentSize = 0L;
        type = null;
        try {
            path = this.filePath != null ? this.filePath : ((url = this.getResource(iRequest)).startsWith("/www") != false ? String.valueOf(this.rootPath) + url.substring("/www".length(), url.length()) : String.valueOf(this.rootPath) + (String)url);
            if (this.cacheContents != null) {
                url = this.cacheContents;
                synchronized (url) {
                    cachedEntry = this.cacheContents.get(path);
                    if (cachedEntry != null) {
                        is = new ByteArrayInputStream(cachedEntry.content);
                        contentSize = cachedEntry.size;
                        type = cachedEntry.type;
                    }
                }
            }
            if (is != null) ** GOTO lbl65
            inputFile = new File(path);
            if (!inputFile.exists()) {
                OLogManager.instance().debug((Object)this, "Static resource not found: %s", new Object[]{path});
                this.sendBinaryContent(iRequest, 404, "File not found", null, null, 0L);
                return false;
            }
            try {
                if (this.filePath == null && inputFile.isDirectory()) {
                    inputFile = new File(String.valueOf(path) + "/index.htm");
                    if (inputFile.exists()) {
                        path = String.valueOf(path) + "/index.htm";
                    } else {
                        inputFile = new File(String.valueOf(path) + "/index.html");
                        if (inputFile.exists()) {
                            path = String.valueOf(path) + "/index.html";
                        }
                    }
                }
                type = path.endsWith(".htm") != false || path.endsWith(".html") != false ? "text/html" : (path.endsWith(".png") != false ? "image/png" : (path.endsWith(".jpeg") != false ? "image/jpeg" : (path.endsWith(".js") != false ? "application/x-javascript" : (path.endsWith(".css") != false ? "text/css" : (path.endsWith(".ico") != false ? "image/x-icon" : (path.endsWith(".otf") != false ? "font/opentype" : "text/plain"))))));
                is = new BufferedInputStream(new FileInputStream(inputFile));
                contentSize = inputFile.length();
                if (this.cacheContents != null) {
                    buffer = new byte[(int)contentSize];
                    i = 0;
                    while ((long)i < contentSize) {
                        buffer[i] = (byte)is.read();
                        ++i;
                    }
                    cachedEntry = new OStaticContentCachedEntry();
                    cachedEntry.content = buffer;
                    cachedEntry.size = contentSize;
                    cachedEntry.type = type;
                    this.cacheContents.put(path, cachedEntry);
                    is = new ByteArrayInputStream(cachedEntry.content);
                }
lbl65:
                // 4 sources

                this.sendBinaryContent(iRequest, 200, "OK", type, is, contentSize);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException var11_9) {}
            }
        }
        return false;
    }

    @Override
    protected void onBeforeResponseHeader(OHttpRequest iRequest) throws IOException {
        String header = this.cacheHttpDefault;
        if (this.cacheHttp.size() > 0) {
            String resource = this.getResource(iRequest);
            for (Map.Entry<String, String> entry : this.cacheHttp.entrySet()) {
                int wildcardPos = entry.getKey().indexOf(42);
                String partLeft = entry.getKey().substring(0, wildcardPos);
                String partRight = entry.getKey().substring(wildcardPos + 1);
                if (!resource.startsWith(partLeft) || !resource.endsWith(partRight)) continue;
                header = entry.getValue();
                break;
            }
        }
        this.writeLine(iRequest, header);
    }

    protected String getResource(OHttpRequest iRequest) {
        int pos;
        String url = "/".equals(iRequest.url) ? "/www/index.htm" : ((pos = iRequest.url.indexOf(63)) > -1 ? iRequest.url.substring(0, pos) : iRequest.url);
        return url;
    }
}

