/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;

public class OServerCommandPostDocument
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"POST|document/*"};

    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        this.checkSyntax(iRequest.url, 2, "Syntax error: document/<database>");
        iRequest.data.commandInfo = "Create document";
        ODatabaseDocumentTx db = null;
        ODocument doc = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            doc = (ODocument)new ODocument().fromJSON(iRequest.content);
            ((ORecordId)doc.getIdentity()).clusterPosition = -1L;
            doc.save();
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        this.sendTextContent(iRequest, 201, "Created", null, "text/plain", doc.getIdentity());
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

