/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartContentBaseParser;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartDatabaseImportContentParser;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartRequestCommand;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;

public class OServerCommandPostImportDatabase
extends OHttpMultipartRequestCommand<String, InputStream>
implements OCommandOutputListener {
    protected static final String[] NAMES = new String[]{"POST|import/*"};
    protected StringWriter buffer;
    protected InputStream importData;
    protected ODatabaseRecord database;

    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        if (!iRequest.isMultipart) {
            this.sendTextContent(iRequest, 405, "Request is not multipart/form-data", null, "text/plain", "Request is not multipart/form-data");
        } else if (iRequest.multipartStream == null || iRequest.multipartStream.available() <= 0) {
            this.sendTextContent(iRequest, 405, "Content stream is null or empty", null, "text/plain", "Content stream is null or empty");
        } else {
            this.database = this.getProfiledDatabaseInstance(iRequest);
            try {
                try {
                    this.parse(iRequest, new OHttpMultipartContentBaseParser(), new OHttpMultipartDatabaseImportContentParser(), this.database);
                    ODatabaseImport importer = new ODatabaseImport((ODatabaseDocument)this.getProfiledDatabaseInstance(iRequest), this.importData, (OCommandOutputListener)this);
                    importer.importDatabase();
                    this.sendTextContent(iRequest, 200, "OK", null, "application/json", "{\"responseText\": \"Database imported Correctly, see server log for more informations.\"}");
                }
                catch (Exception e) {
                    this.sendTextContent(iRequest, 500, String.valueOf(e.getMessage()) + ": " + e.getCause() != null ? e.getCause().getMessage() : "", null, "application/json", "{\"responseText\": \"" + e.getMessage() + ": " + (e.getCause() != null ? e.getCause().getMessage() : "") + "\"}");
                    if (this.database != null) {
                        this.database.close();
                    }
                    this.database = null;
                    if (this.importData != null) {
                        this.importData.close();
                    }
                    this.importData = null;
                }
            }
            finally {
                if (this.database != null) {
                    this.database.close();
                }
                this.database = null;
                if (this.importData != null) {
                    this.importData.close();
                }
                this.importData = null;
            }
        }
        return false;
    }

    @Override
    protected void processBaseContent(OHttpRequest iRequest, String iContentResult, HashMap<String, String> headers) throws Exception {
    }

    @Override
    protected void processFileContent(OHttpRequest iRequest, InputStream iContentResult, HashMap<String, String> headers) throws Exception {
        this.importData = iContentResult;
    }

    @Override
    protected String getDocumentParamenterName() {
        return "linkValue";
    }

    @Override
    protected String getFileParamenterName() {
        return "databaseFile";
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    public void onMessage(String iText) {
        OLogManager.instance().info((Object)this, iText, new Object[0]);
    }
}

