/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.multipart;

import java.io.IOException;
import java.io.InputStream;

public class OHttpMultipartBaseInputStream
extends InputStream {
    protected StringBuilder buffer;
    protected int contentLength = 0;
    protected InputStream wrappedInputStream;

    public OHttpMultipartBaseInputStream(InputStream in, int iSkipInput, int iContentLength) {
        this.wrappedInputStream = in;
        this.contentLength = iContentLength;
        this.buffer = new StringBuilder();
        this.buffer.append((char)iSkipInput);
    }

    public OHttpMultipartBaseInputStream(InputStream in, char iSkipInput, int iContentLength) {
        this.wrappedInputStream = in;
        this.contentLength = iContentLength;
        this.buffer = new StringBuilder();
        this.buffer.append(iSkipInput);
    }

    public InputStream getWrappedInputStream() {
        return this.wrappedInputStream;
    }

    public void setSkipInput(int iSkipInput) {
        this.buffer.append((char)iSkipInput);
        ++this.contentLength;
    }

    public void setSkipInput(StringBuilder iSkipInput) {
        this.buffer.append((CharSequence)iSkipInput);
        this.contentLength += iSkipInput.length();
    }

    @Override
    public synchronized int available() throws IOException {
        return this.contentLength;
    }

    @Override
    public synchronized int read() throws IOException {
        --this.contentLength;
        if (this.buffer.length() > 0) {
            char returnValue = this.buffer.charAt(0);
            this.buffer.deleteCharAt(0);
            return returnValue;
        }
        return this.wrappedInputStream.read();
    }

    @Override
    public void close() throws IOException {
        this.wrappedInputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.wrappedInputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.wrappedInputStream.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer.length() > 0) {
            int tot2Read = Math.min(this.buffer.length(), len);
            int i = 0;
            while (i < tot2Read) {
                b[i] = (byte)this.buffer.charAt(0);
                this.buffer.deleteCharAt(0);
                --this.contentLength;
                ++i;
            }
            return tot2Read;
        }
        int totRead = this.wrappedInputStream.read(b, off, len);
        this.contentLength -= totRead;
        return totRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrappedInputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.wrappedInputStream.skip(n);
    }

    public String toString() {
        return this.wrappedInputStream.toString();
    }

    public void resetBuffer() {
        this.buffer.setLength(0);
    }

    public int wrappedAvailable() throws IOException {
        return this.wrappedInputStream.available();
    }
}

