/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.multipart;

import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartBaseInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OHttpMultipartContentInputStream
extends InputStream {
    protected String boundary;
    protected OHttpMultipartBaseInputStream wrappedInputStream;
    protected int previousData;
    protected boolean internalAvailable = true;

    public OHttpMultipartContentInputStream(OHttpMultipartBaseInputStream in, String iBoundary) throws IOException {
        this.wrappedInputStream = in;
        this.boundary = "\n--" + iBoundary;
    }

    public InputStream getWrappedInputStream() {
        return this.wrappedInputStream;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.internalAvailable) {
            return this.wrappedInputStream.available();
        }
        return -1;
    }

    @Override
    public synchronized int read() throws IOException {
        int value = this.previousData;
        this.previousData = this.wrappedInputStream.read();
        if ((char)this.previousData == '\r') {
            this.bufferData();
        }
        return value;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.wrappedInputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.wrappedInputStream.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.wrappedInputStream.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.wrappedInputStream.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.previousData = this.wrappedInputStream.read();
        this.internalAvailable = true;
        if ((char)this.previousData == '\r') {
            this.bufferData();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this.wrappedInputStream.skip(n);
    }

    public String toString() {
        return this.wrappedInputStream.toString();
    }

    protected void bufferData() throws IOException {
        int b;
        boolean checkingEnd = true;
        int boundaryCursor = 0;
        StringBuilder buffer = new StringBuilder();
        while ((b = this.wrappedInputStream.read()) > 0 && checkingEnd) {
            buffer.append((char)b);
            if ((char)b == this.boundary.charAt(boundaryCursor)) {
                this.internalAvailable = false;
                if (++boundaryCursor != this.boundary.length()) continue;
                checkingEnd = false;
                this.wrappedInputStream.resetBuffer();
                continue;
            }
            this.internalAvailable = true;
            checkingEnd = false;
            if (buffer.length() <= 0) continue;
            this.wrappedInputStream.setSkipInput(buffer);
        }
    }
}

