/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.replication;

import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.replication.ONodeConnection;
import com.orientechnologies.orient.server.replication.OOperationLog;
import java.io.IOException;
import java.util.logging.Level;

public class ODistributedDatabaseInfo {
    public String serverId;
    public String databaseName;
    public String userName;
    public String userPassword;
    public SYNCH_TYPE synchType;
    public ONodeConnection connection;
    public STATUS_TYPE status;
    private OOperationLog log;
    private final OClusterLogger logger = new OClusterLogger();

    public ODistributedDatabaseInfo(String iServerid, String dbName, String iUserName, String iUserPasswd, SYNCH_TYPE iSynchType, STATUS_TYPE iStatus) throws IOException {
        this.serverId = iServerid;
        this.databaseName = dbName;
        this.userName = iUserName;
        this.userPassword = iUserPasswd;
        this.synchType = iSynchType;
        this.status = iStatus;
        this.logger.setDatabase(dbName);
        this.logger.setNode(iServerid);
        this.log = new OOperationLog(this.serverId, this.databaseName, false);
    }

    public void close() throws IOException {
        if (this.log != null) {
            this.log.close();
        }
        this.setStatus(STATUS_TYPE.OFFLINE);
    }

    public boolean isOnline() {
        return this.status == STATUS_TYPE.ONLINE;
    }

    public void setOnline() {
        this.setStatus(STATUS_TYPE.ONLINE);
    }

    public void setSynchronizing() {
        this.setStatus(STATUS_TYPE.SYNCHRONIZING);
    }

    public void setOffline() {
        this.setStatus(STATUS_TYPE.OFFLINE);
    }

    public OOperationLog getLog() {
        return this.log;
    }

    private void setStatus(STATUS_TYPE iStatus) {
        this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.NONE, "distributed db changed status %s -> %s", new Object[]{this.status, iStatus});
        this.status = iStatus;
    }

    public static enum STATUS_TYPE {
        ONLINE,
        OFFLINE,
        SYNCHRONIZING;

    }

    public static enum SYNCH_TYPE {
        SYNCH,
        ASYNCH;

    }
}

