/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.replication;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterPositionIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.enterprise.channel.binary.OAsynchChannelServiceThread;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynch;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryOutputStream;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.clustering.leader.ORemoteNodeAbstract;
import com.orientechnologies.orient.server.replication.ODistributedDatabaseInfo;
import com.orientechnologies.orient.server.replication.ODistributedRemoteAsynchEventListener;
import com.orientechnologies.orient.server.replication.OReplicator;
import com.orientechnologies.orient.server.replication.conflict.OReplicationConflictResolver;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;

public class ONodeConnection
extends ORemoteNodeAbstract
implements OCommandOutputListener {
    private final OReplicationConflictResolver conflictResolver;
    protected final ExecutorService asynchExecutor;
    protected final OReplicator replicator;

    public ONodeConnection(OReplicator iReplicator, String iNodeId, OReplicationConflictResolver iConflictResolver) throws IOException {
        super(iNodeId.split(":")[0], Integer.parseInt(iNodeId.split(":")[1]));
        this.replicator = iReplicator;
        this.logger.setNode(iNodeId);
        this.connect();
        this.conflictResolver = iConflictResolver;
        this.asynchExecutor = Executors.newSingleThreadExecutor();
    }

    public void synchronize(String iDatabaseName, Set<ODocument> iDbCfg) {
        this.logger.setDatabase(iDatabaseName);
        this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "synchronization started. Storing delta of updates...", new Object[0]);
        try {
            ODocument cfg = new ODocument().field("nodes", iDbCfg, OType.EMBEDDEDSET);
            this.connect();
            ODatabaseComplex<?> database = OServerMain.server().openDatabase("document", iDatabaseName, this.replicator.getReplicatorUser().name, this.replicator.getReplicatorUser().password);
            try {
                this.conflictResolver.init(database);
                OChannelBinaryClient network = this.beginRequest((byte)104);
                try {
                    network.writeString(iDatabaseName);
                    network.writeBytes(cfg.toStream());
                    network.flush();
                }
                finally {
                    this.endRequest();
                }
                this.parseResponse();
            }
            finally {
                database.close();
            }
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OIOException("REPL DB (" + iDatabaseName + ") error on synchronization", (Throwable)e);
        }
    }

    public void align(String iDatabaseName, String iOptions) {
        this.logger.setDatabase(iDatabaseName);
        this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "alignment started with options %s", iOptions);
        try {
            this.connect();
            String path = OServerMain.server().getStoragePath(iDatabaseName);
            ODatabaseComplex<?> database = OServerMain.server().openDatabase("document", path, this.replicator.getReplicatorUser().name, this.replicator.getReplicatorUser().password);
            try {
                this.conflictResolver.init(database);
                int blockSize = OGlobalConfiguration.DISTRIBUTED_ALIGN_RECORD_BLOCK.getValueAsInteger();
                ODocument cfg = new ODocument();
                cfg.field("db", (Object)iDatabaseName);
                ODocument block = new ODocument().addOwner((ORecordElement)cfg);
                cfg.field("block", (Object)block);
                int current = 0;
                OPhysicalPosition ppos = new OPhysicalPosition();
                for (OCluster cluster : database.getStorage().getClusterInstances()) {
                    OClusterPositionIterator iterator = cluster.absoluteIterator();
                    while (iterator.hasNext()) {
                        ppos.clusterPosition = iterator.next();
                        try {
                            cluster.getPhysicalPosition(ppos);
                            block.field(String.valueOf(cluster.getId()) + "_" + ppos.clusterPosition, (Object)ppos.recordVersion);
                            if (++current % blockSize != 0) continue;
                            this.sendAlignmentBlock(cfg);
                            current = 0;
                        }
                        catch (Exception e) {
                            this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "Error on loading record %d:%d because: %s", cluster.getId(), ppos.clusterPosition, e.toString());
                        }
                    }
                }
                if (current > 0) {
                    this.sendAlignmentBlock(cfg);
                }
            }
            finally {
                database.close();
            }
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OIOException("REPL DB (" + iDatabaseName + ") error on alignment", (Throwable)e);
        }
    }

    protected void sendAlignmentBlock(ODocument cfg) throws IOException {
        OChannelBinaryClient network = this.beginRequest((byte)107);
        try {
            network.writeBytes(cfg.toStream());
            network.flush();
        }
        finally {
            this.endRequest();
            ((ODocument)cfg.field("block")).clear();
        }
        this.parseResponse();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ORecord<?> requestRecord(ODistributedDatabaseInfo databaseEntry, ORecordId rid) {
        this.logger.setNode(databaseEntry.serverId);
        this.logger.setDatabase(databaseEntry.databaseName);
        if (OLogManager.instance().isInfoEnabled()) {
            this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "%s record", rid);
        }
        try {
            OChannelBinaryClient network = this.beginRequest((byte)106);
            try {
                network.writeString(databaseEntry.databaseName);
                network.writeRID((ORID)rid);
            }
            finally {
                this.endRequest();
            }
            this.beginResponse();
            try {
                byte recordType = network.readByte();
                if (recordType <= -1) return null;
                ORecordInternal record = Orient.instance().getRecordFactoryManager().newInstance(recordType);
                record.fill(rid, network.readInt(), network.readBytes(), false);
                ORecordInternal oRecordInternal = record;
                return oRecordInternal;
            }
            finally {
                this.endResponse();
            }
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OIOException("REPL <" + databaseEntry.databaseName + "> error on reading record: " + rid, (Throwable)e);
        }
    }

    public void propagateChange(ODistributedDatabaseInfo databaseEntry, final ORecordOperation iRequest, final ODistributedDatabaseInfo.SYNCH_TYPE iRequestType, final ORecordInternal<?> iRecord) {
        if (OLogManager.instance().isInfoEnabled()) {
            this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "%s record %s in %s mode", new Object[]{ORecordOperation.getName((int)iRequest.type), iRecord.getIdentity(), iRequestType});
        }
        if (this.conflictResolver.searchForConflict((OIdentifiable)iRecord.getIdentity()) != null) {
            if (OLogManager.instance().isDebugEnabled()) {
                this.logger.log((Object)this, Level.FINEST, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "record %s is in conflict, avoid propagation", iRecord.getIdentity());
            }
            return;
        }
        this.logger.setNode(databaseEntry.serverId);
        this.logger.setDatabase(databaseEntry.databaseName);
        final ODatabaseRecord localDatabase = ODatabaseRecordThreadLocal.INSTANCE.get();
        try {
            final OChannelBinaryClient network = this.beginRequest((byte)105);
            try {
                network.writeString(databaseEntry.databaseName);
                network.writeByte(iRequest.type);
                network.writeLong(iRequest.serial);
                network.writeRID(iRecord.getIdentity());
                network.writeBytes(iRecord.toStream());
                network.writeInt(iRecord.getVersion());
                network.writeByte(iRecord.getRecordType());
            }
            finally {
                this.endRequest();
            }
            if (iRequestType == ODistributedDatabaseInfo.SYNCH_TYPE.SYNCH) {
                this.beginResponse();
                try {
                    this.handleRemoteResponse(iRequest.type, iRequestType, iRecord, network.readLong());
                }
                finally {
                    this.endResponse();
                }
            } else {
                Callable<Object> response = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ODatabaseRecordThreadLocal.INSTANCE.set((Object)localDatabase);
                        ONodeConnection.this.beginResponse();
                        try {
                            ONodeConnection.this.handleRemoteResponse(iRequest.type, iRequestType, iRecord, network.readLong());
                        }
                        finally {
                            ONodeConnection.this.endResponse();
                        }
                        return null;
                    }
                };
                this.asynchExecutor.submit(new FutureTask<Object>(response));
            }
            return;
        }
        catch (OConcurrentModificationException e) {
            this.conflictResolver.handleUpdateConflict(iRequest.type, iRequestType, iRecord, e.getRecordVersion(), e.getDatabaseVersion());
            return;
        }
        catch (ODatabaseException e) {
            this.conflictResolver.handleUpdateConflict(iRequest.type, iRequestType, iRecord, iRecord.getVersion(), -1);
            return;
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OIOException("REPL <" + databaseEntry.databaseName + "> error on distribute record: " + iRecord.getIdentity(), (Throwable)e);
        }
    }

    public void copy(ODatabaseRecord iDatabase, String dbName, String iDbUser, String iDbPasswd, String iEngineName) throws IOException {
        this.checkConnection();
        OChannelBinaryClient network = this.beginRequest((byte)103);
        try {
            network.writeString(dbName);
            network.writeString(iDbUser);
            network.writeString(iDbPasswd);
            network.writeString(iDatabase.getType());
            network.writeString(iEngineName);
            new ODatabaseExport(iDatabase, (OutputStream)new OChannelBinaryOutputStream((OChannelBinaryAsynch)network), (OCommandOutputListener)this).exportDatabase();
        }
        finally {
            this.endRequest();
        }
        this.parseResponse();
    }

    private void handleRemoteResponse(byte iOperation, ODistributedDatabaseInfo.SYNCH_TYPE iRequestType, ORecordInternal<?> iRecord, long iResponse) {
        switch (iOperation) {
            case 3: {
                if (iResponse == iRecord.getIdentity().getClusterPosition()) break;
                this.conflictResolver.handleCreateConflict((byte)3, iRequestType, iRecord, iResponse);
                break;
            }
            case 1: {
                if ((int)iResponse == iRecord.getVersion()) break;
                this.conflictResolver.handleUpdateConflict((byte)1, iRequestType, iRecord, iRecord.getVersion(), (int)iResponse);
                break;
            }
            case 2: {
                if ((int)iResponse != 0) break;
                this.conflictResolver.handleDeleteConflict((byte)2, iRequestType, iRecord);
            }
        }
    }

    public void onMessage(String iText) {
    }

    @Override
    protected void connect() throws IOException {
        if (this.checkConnection()) {
            return;
        }
        this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "connecting...", this.getId());
        this.channel = new OChannelBinaryClient(this.networkAddress, this.networkPort, new OContextConfiguration(), 0);
        this.beginRequest((byte)100);
        try {
            this.channel.writeString(this.replicator.getManager().getId());
            this.channel.writeString(this.replicator.getReplicatorUser().name);
            this.channel.writeString(this.replicator.getReplicatorUser().password);
        }
        finally {
            this.endRequest();
        }
        this.parseResponse();
        this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "connected", new Object[0]);
        this.serviceThread = new OAsynchChannelServiceThread((ORemoteServerEventListener)new ODistributedRemoteAsynchEventListener(this.replicator.getManager(), new ODistributedRemoteAsynchEventListener(this.replicator.getManager(), null, this.getId()), this.getId()), this.channel, "OrientDB <- Asynch Node/" + this.getId());
    }
}

