/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.replication.conflict;

import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.replication.ODistributedDatabaseInfo;
import com.orientechnologies.orient.server.replication.OReplicator;
import com.orientechnologies.orient.server.replication.conflict.OReplicationConflictResolver;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ODefaultReplicationConflictResolver
implements OReplicationConflictResolver {
    public static final String DISTRIBUTED_CONFLICT_CLASS = "ODistributedConflict";
    private static final String FIELD_RECORD = "record";
    private static final String FIELD_DATE = "date";
    private static final String FIELD_OPERATION = "operation";
    private static final String FIELD_OTHER_CLUSTER_POS = "otherClusterPos";
    private static final String FIELD_OTHER_VERSION = "otherVersion";
    private static final String FIELD_CURRENT_VERSION = "currentVersion";
    private OReplicator replicator;
    private final OClusterLogger logger = new OClusterLogger();
    private boolean ignoreIfSameContent;
    private boolean ignoreIfMergeOk;
    private boolean latestAlwaysWin;
    private OIndex<?> index = null;

    @Override
    public void config(OReplicator iReplicator, Map<String, String> iConfig) {
        this.replicator = iReplicator;
        this.replicator.addIgnoredDocumentClass(DISTRIBUTED_CONFLICT_CLASS);
        this.replicator.addIgnoredCluster("internal");
        this.replicator.addIgnoredCluster("index");
        this.ignoreIfSameContent = Boolean.parseBoolean(iConfig.get("ignoreIfSameContent"));
        this.ignoreIfMergeOk = Boolean.parseBoolean(iConfig.get("ignoreIfMergeOk"));
        this.latestAlwaysWin = Boolean.parseBoolean(iConfig.get("latestAlwaysWin"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ODatabaseComplex<?> iDatabase) {
        ODefaultReplicationConflictResolver oDefaultReplicationConflictResolver = this;
        synchronized (oDefaultReplicationConflictResolver) {
            if (this.index != null) {
                return;
            }
            OClass cls = iDatabase.getMetadata().getSchema().getClass(DISTRIBUTED_CONFLICT_CLASS);
            if (cls == null) {
                cls = iDatabase.getMetadata().getSchema().createClass(DISTRIBUTED_CONFLICT_CLASS);
                this.index = cls.createProperty(FIELD_RECORD, OType.LINK).createIndex(OClass.INDEX_TYPE.UNIQUE);
            } else {
                OProperty p = cls.getProperty(FIELD_RECORD);
                this.index = p == null ? cls.createProperty(FIELD_RECORD, OType.LINK).createIndex(OClass.INDEX_TYPE.UNIQUE) : p.getIndex();
            }
        }
    }

    @Override
    public void handleCreateConflict(byte iOperation, ODistributedDatabaseInfo.SYNCH_TYPE iRequestType, ORecordInternal<?> iRecord, long iOtherClusterPosition) {
        this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "CONFLICT %s record %s (other RID=#%d:%d)...", ORecordOperation.getName((int)iOperation), iRecord.getIdentity(), iRecord.getIdentity().getClusterId(), iOtherClusterPosition);
        if (this.searchForConflict((OIdentifiable)iRecord) != null) {
            this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "Conflict already present for record %s, skip it", iRecord.getIdentity());
        } else {
            ODocument doc = this.createConflictDocument(iOperation, iRecord);
            doc.field(FIELD_OTHER_CLUSTER_POS, (Object)iOtherClusterPosition);
            doc.save();
        }
    }

    @Override
    public void handleUpdateConflict(byte iOperation, ODistributedDatabaseInfo.SYNCH_TYPE iRequestType, ORecordInternal<?> iRecord, int iCurrentVersion, int iOtherVersion) {
        this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "CONFLICT %s record %s (current=v%d, other=v%d)...", ORecordOperation.getName((int)iOperation), iRecord.getIdentity(), iCurrentVersion, iOtherVersion);
        if (this.searchForConflict((OIdentifiable)iRecord) != null) {
            this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "Conflict already present for record %s, skip it", iRecord.getIdentity());
        } else {
            ODocument doc = this.createConflictDocument(iOperation, iRecord);
            doc.field(FIELD_CURRENT_VERSION, (Object)iCurrentVersion);
            doc.field(FIELD_OTHER_VERSION, (Object)iOtherVersion);
            doc.save();
        }
    }

    @Override
    public void handleDeleteConflict(byte iOperation, ODistributedDatabaseInfo.SYNCH_TYPE iRequestType, ORecordInternal<?> iRecord) {
        this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "-> %s (%s mode) CONFLICT %s record %s (cannot be deleted on other node)", ORecordOperation.getName((int)iOperation), iRecord.getIdentity());
        if (this.searchForConflict((OIdentifiable)iRecord) != null) {
            this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "Conflict already present for record %s, skip it", iRecord.getIdentity());
        } else {
            ODocument doc = this.createConflictDocument(iOperation, iRecord);
            doc.save();
        }
    }

    @Override
    public ODocument getAllConflicts(ODatabaseRecord iDatabase) {
        List entries = iDatabase.query((OQuery)new OSQLSynchQuery("select from ODistributedConflict"), new Object[0]);
        ODocument result = new ODocument().field("entries", (Object)entries);
        int i = 0;
        while (i < entries.size()) {
            ODocument record = (ODocument)((OIdentifiable)entries.get(i)).getRecord();
            record.setClassName(null);
            record.addOwner((ORecordElement)result);
            record.getIdentity().reset();
            entries.set(i, record);
            ++i;
        }
        return result;
    }

    @Override
    public OIdentifiable searchForConflict(OIdentifiable iRecord) {
        return (OIdentifiable)this.index.get((Object)iRecord);
    }

    protected ODocument createConflictDocument(byte iOperation, ORecordInternal<?> iRecord) {
        ODocument doc = new ODocument(DISTRIBUTED_CONFLICT_CLASS);
        doc.field(FIELD_OPERATION, (Object)iOperation);
        doc.field(FIELD_DATE, (Object)new Date());
        doc.field(FIELD_RECORD, (Object)iRecord.getIdentity());
        return doc;
    }

    public String toString() {
        return this.replicator.getManager().getId();
    }
}

